/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.reflect;

import java.util.function.Function;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectConfiguration;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyAccessStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyDefaultValueStrategy;

public class DefaultReflectConfiguration
implements ReflectConfiguration {
    private Function<Class, ReflectPropertyAccessStrategy> propertyAccessStrategy;
    private Function<Class, ReflectPropertyDefaultValueStrategy> propertyDefaultValueStrategy;

    public DefaultReflectConfiguration(Function<Class, ReflectPropertyAccessStrategy> propertyAccessStrategy, Function<Class, ReflectPropertyDefaultValueStrategy> propertyDefaultValueStrategy) {
        this.propertyAccessStrategy = propertyAccessStrategy;
        this.propertyDefaultValueStrategy = propertyDefaultValueStrategy;
    }

    @Override
    public ReflectPropertyAccessStrategy getAccessStrategy(Class clz) {
        if (this.propertyAccessStrategy == null) {
            return ReflectPropertyAccessStrategy.FIELD;
        }
        ReflectPropertyAccessStrategy v = this.propertyAccessStrategy.apply(clz);
        return v != null ? v : ReflectPropertyAccessStrategy.FIELD;
    }

    @Override
    public ReflectPropertyDefaultValueStrategy getDefaultValueStrategy(Class clz) {
        if (this.propertyAccessStrategy == null) {
            return ReflectPropertyDefaultValueStrategy.TYPE_DEFAULT;
        }
        ReflectPropertyDefaultValueStrategy v = this.propertyDefaultValueStrategy.apply(clz);
        return v != null ? v : ReflectPropertyDefaultValueStrategy.PROPERTY_DEFAULT;
    }
}

