/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.bundles.reflect.FieldReflectProperty;
import net.thevpc.nuts.runtime.bundles.reflect.MethodReflectProperty1;
import net.thevpc.nuts.runtime.bundles.reflect.MethodReflectProperty2;
import net.thevpc.nuts.runtime.bundles.reflect.MethodReflectProperty3;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectProperty;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyAccessStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectRepository;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectType;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectUtils;

public class ClassReflectType
implements ReflectType {
    private static final Pattern GETTER_SETTER = Pattern.compile("(?<prefix>(get|set|is))(?<suffix>([A-Z][a-zA-Z_]*))");
    private Type type;
    private Class clazz;
    private Map<String, ReflectProperty> direct;
    private List<ReflectProperty> directList;
    private Map<String, ReflectProperty> all;
    private List<ReflectProperty> allList;
    private ReflectRepository repo;
    private ReflectPropertyAccessStrategy propertyAccessStrategy;
    private ReflectPropertyDefaultValueStrategy propertyDefaultValueStrategy;
    private Constructor noArgConstr;

    public ClassReflectType(Type type, ReflectPropertyAccessStrategy propertyAccessStrategy, ReflectPropertyDefaultValueStrategy propertyDefaultValueStrategy, ReflectRepository repo) {
        this.type = type;
        this.repo = repo;
        this.propertyAccessStrategy = propertyAccessStrategy;
        this.propertyDefaultValueStrategy = propertyDefaultValueStrategy;
        this.clazz = ReflectUtils.getRawClass(type);
    }

    @Override
    public ReflectPropertyDefaultValueStrategy getDefaultValueStrategy() {
        return this.propertyDefaultValueStrategy;
    }

    @Override
    public ReflectPropertyAccessStrategy getAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    @Override
    public Object newInstance() {
        if (this.noArgConstr == null) {
            try {
                this.noArgConstr = this.clazz.getConstructor(new Class[0]);
                this.noArgConstr.setAccessible(true);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("Unable to resolve default constructore fo " + this.clazz, ex);
            }
            catch (SecurityException ex) {
                throw new IllegalArgumentException("Not allowed to access default constructor for " + this.clazz, ex);
            }
        }
        try {
            return this.noArgConstr.newInstance(new Object[0]);
        }
        catch (InstantiationException | InvocationTargetException ex) {
            Throwable c = ex.getCause();
            if (c instanceof RuntimeException) {
                throw (RuntimeException)c;
            }
            throw new IllegalArgumentException(c);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private void build() {
        if (this.direct == null) {
            Object cleanInstance = null;
            try {
                cleanInstance = this.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinkedHashMap<String, ReflectProperty> declaredProperties = new LinkedHashMap<String, ReflectProperty>();
            LinkedHashMap<String, ReflectProperty> fieldAllProperties = new LinkedHashMap<String, ReflectProperty>();
            HashSet<String> ambiguousWrites = new HashSet<String>();
            this.fillFields(this.clazz, declaredProperties, cleanInstance, ambiguousWrites, this.propertyAccessStrategy, this.propertyDefaultValueStrategy);
            fieldAllProperties.putAll(declaredProperties);
            for (Class parent = this.clazz.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                ReflectPropertyAccessStrategy _propertyAccessStrategy = this.repo.getConfiguration().getAccessStrategy(parent);
                ReflectPropertyDefaultValueStrategy _propertyDefaultValueStrategy = this.repo.getConfiguration().getDefaultValueStrategy(parent);
                this.fillFields(parent, fieldAllProperties, cleanInstance, ambiguousWrites, _propertyAccessStrategy, _propertyDefaultValueStrategy);
            }
            this.direct = declaredProperties;
            this.all = fieldAllProperties;
            this.directList = Collections.unmodifiableList(new ArrayList<ReflectProperty>(this.direct.values()));
            this.allList = Collections.unmodifiableList(new ArrayList<ReflectProperty>(this.all.values()));
        }
    }

    private void fillFields(Class clazz, LinkedHashMap<String, ReflectProperty> declaredProperties, Object cleanInstance, Set<String> ambiguousWrites, ReflectPropertyAccessStrategy propertyAccessStrategy, ReflectPropertyDefaultValueStrategy propertyDefaultValueStrategy) {
        if (propertyAccessStrategy == ReflectPropertyAccessStrategy.METHOD || propertyAccessStrategy == ReflectPropertyAccessStrategy.BOTH) {
            LinkedHashMap<String, Method> methodGetters = new LinkedHashMap<String, Method>();
            LinkedHashMap<String, ArrayList<Method>> methodSetters = new LinkedHashMap<String, ArrayList<Method>>();
            block12: for (Method m : clazz.getDeclaredMethods()) {
                String name;
                Matcher matcher;
                if (m.isSynthetic() || Modifier.isAbstract(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || !(matcher = GETTER_SETTER.matcher(name = m.getName())).find()) continue;
                char[] n2c = matcher.group("suffix").toCharArray();
                n2c[0] = Character.toLowerCase(n2c[0]);
                String n2 = new String(n2c);
                switch (matcher.group("prefix")) {
                    case "get": {
                        if (m.getParameterCount() != 0 || m.getReturnType().equals(Void.TYPE) || name.equals("getClass")) continue block12;
                        methodGetters.put(n2, m);
                        continue block12;
                    }
                    case "is": {
                        if (m.getParameterCount() != 0 || !m.getReturnType().equals(Boolean.TYPE) && !m.getReturnType().equals(Boolean.class)) continue block12;
                        methodGetters.put(n2, m);
                        continue block12;
                    }
                    case "set": {
                        if (m.getParameterCount() != 1) continue block12;
                        ArrayList<Method> li = (ArrayList<Method>)methodSetters.get(n2);
                        if (li == null) {
                            li = new ArrayList<Method>();
                            methodSetters.put(n2, li);
                        }
                        li.add(m);
                    }
                }
            }
            for (Map.Entry entry : methodGetters.entrySet()) {
                String propName = (String)entry.getKey();
                if (declaredProperties.containsKey(propName)) continue;
                Method readMethod = (Method)entry.getValue();
                Method writeMethod = null;
                Field writeField = null;
                List possibleSetters = (List)methodSetters.get(propName);
                if (possibleSetters != null) {
                    for (Method posibleSetter : possibleSetters) {
                        Class<?> ps = posibleSetter.getParameterTypes()[0];
                        if (!ps.equals(readMethod.getReturnType())) continue;
                        writeMethod = posibleSetter;
                        methodSetters.remove(propName);
                        break;
                    }
                }
                if (writeMethod == null && propertyAccessStrategy == ReflectPropertyAccessStrategy.BOTH) {
                    for (Field f : clazz.getDeclaredFields()) {
                        if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || declaredProperties.containsKey(f.getName()) || Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || !f.getType().equals(readMethod.getReturnType())) continue;
                        writeField = f;
                    }
                }
                if (writeMethod != null) {
                    declaredProperties.put(propName, new MethodReflectProperty1(propName, readMethod, writeMethod, cleanInstance, this, propertyDefaultValueStrategy));
                    continue;
                }
                if (writeField != null) {
                    declaredProperties.put(propName, new MethodReflectProperty2(propName, readMethod, writeField, cleanInstance, this, propertyDefaultValueStrategy));
                    continue;
                }
                declaredProperties.put(propName, new MethodReflectProperty1(propName, readMethod, null, cleanInstance, this, propertyDefaultValueStrategy));
            }
            for (Map.Entry entry : methodSetters.entrySet()) {
                String propName = (String)entry.getKey();
                if (((List)entry.getValue()).size() == 1) {
                    Method writeMethod = (Method)((List)entry.getValue()).get(0);
                    if (declaredProperties.containsKey(propName)) continue;
                    Field readField = null;
                    try {
                        readField = clazz.getDeclaredField(propName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (readField == null || Modifier.isStatic(readField.getModifiers()) || !readField.getType().equals(writeMethod.getParameterTypes()[0])) continue;
                    declaredProperties.put(propName, new MethodReflectProperty3(propName, readField, writeMethod, cleanInstance, this, propertyDefaultValueStrategy));
                    continue;
                }
                if (((List)entry.getValue()).size() <= 0) continue;
                ambiguousWrites.add(propName);
            }
        }
        if (propertyAccessStrategy == ReflectPropertyAccessStrategy.FIELD || propertyAccessStrategy == ReflectPropertyAccessStrategy.BOTH) {
            for (Field field : clazz.getDeclaredFields()) {
                if (declaredProperties.containsKey(field.getName()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                FieldReflectProperty p = new FieldReflectProperty(field, cleanInstance, this, propertyDefaultValueStrategy);
                declaredProperties.put(p.getName(), p);
            }
        }
    }

    @Override
    public List<ReflectProperty> getDeclaredProperties() {
        this.build();
        return this.directList;
    }

    @Override
    public List<ReflectProperty> getProperties() {
        this.build();
        return this.allList;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }
}

