/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.parsers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.parsers.StringMapParser;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class QueryStringParser {
    private static final StringMapParser QPARSER = new StringMapParser("=", "&");
    private final Map<String, String> properties;
    private final Processor processor;
    private final boolean sorted;

    public QueryStringParser(boolean sorted, Processor processor) {
        this.processor = processor;
        this.sorted = sorted;
        this.properties = sorted ? new TreeMap<String, String>() : new LinkedHashMap<String, String>();
    }

    protected String prepareKey(String key) {
        return NutsUtilStrings.trimToNull((String)key);
    }

    protected String prepareValue(String value) {
        return NutsUtilStrings.trimToNull((String)value);
    }

    public void setProperty(String key, String value) {
        if ((key = this.prepareKey(key)) == null) {
            return;
        }
        value = this.prepareValue(value);
        if (this.processor != null && this.processor.process(key, value)) {
            return;
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int size() {
        return this.properties.size();
    }

    private void _setProperties(Map<String, String> queryMap, boolean merge) {
        if (!merge) {
            this.properties.clear();
        }
        if (queryMap != null) {
            for (Map.Entry<String, String> e : queryMap.entrySet()) {
                this.setProperty(e.getKey(), e.getValue());
            }
        }
    }

    public QueryStringParser setProperties(Map<String, String> queryMap) {
        this._setProperties(queryMap, false);
        return this;
    }

    public void addProperties(Map<String, String> queryMap) {
        this._setProperties(queryMap, true);
    }

    public QueryStringParser setProperties(String propertiesQuery) {
        Map<String, String> m2 = QueryStringParser.parseMap(propertiesQuery);
        this.properties.clear();
        for (Map.Entry<String, String> e : m2.entrySet()) {
            this.setProperty(e.getKey(), e.getValue());
        }
        return this;
    }

    public void addProperties(String propertiesQuery) {
        Map<String, String> m2 = QueryStringParser.parseMap(propertiesQuery);
        for (Map.Entry<String, String> e : m2.entrySet()) {
            this.setProperty(e.getKey(), e.getValue());
        }
    }

    public String getPropertiesQuery() {
        return QueryStringParser.formatPropertiesQuery(this.properties);
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryStringParser that = (QueryStringParser)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public static String formatPropertiesQuery(Map<String, String> query) {
        StringBuilder sb = new StringBuilder();
        if (query != null) {
            TreeSet<String> sortedKeys = new TreeSet<String>(query.keySet());
            for (String k : sortedKeys) {
                String v = query.get(k);
                if (v == null || v.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(CoreStringUtils.simpleQuote(k, true, "&=")).append("=").append(CoreStringUtils.simpleQuote(v, true, "&="));
            }
        }
        return NutsUtilStrings.trimToNull((String)sb.toString());
    }

    public static String formatSortedPropertiesQuery(String query) {
        return new QueryStringParser(true, null).setProperties(query).getPropertiesQuery();
    }

    public static String formatSortedPropertiesQuery(Map<String, String> query) {
        return new QueryStringParser(true, null).setProperties(query).getPropertiesQuery();
    }

    public static Map<String, String> parseMap(String text) {
        return QPARSER.parseMap(text);
    }

    public static interface Processor {
        public boolean process(String var1, String var2);
    }
}

