/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.ntalk;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.thevpc.nuts.runtime.bundles.ntalk.NTalkConstants;
import net.thevpc.nuts.runtime.bundles.ntalk.NTalkUtils;

public class NTalkClient
implements Closeable {
    Socket socket;
    boolean stopped;
    ExecutorService executor;
    DataInputStream inFromBus;
    DataOutputStream outToBus;
    private long id;
    private String challenge;
    private boolean connected;
    private String host;
    private String agentVersion;
    private int port;
    private boolean closed;

    public NTalkClient() {
        this(null, -1);
    }

    public NTalkClient(int port) {
        this(null, port);
    }

    public NTalkClient(String host, int port) {
        this.host = host == null ? "localhost" : host;
        this.port = port <= 0 ? 1401 : port;
        this.connect();
    }

    private void connect() {
        if (this.connected) {
            throw new IllegalArgumentException("already connected");
        }
        try {
            if (this.executor == null) {
                this.executor = Executors.newCachedThreadPool();
            }
            this.socket = new Socket(this.host, this.port);
            this.inFromBus = new DataInputStream(this.socket.getInputStream());
            this.outToBus = new DataOutputStream(this.socket.getOutputStream());
            this.outToBus.writeInt(1);
            int ok = this.inFromBus.readInt();
            if (ok == 256) {
                this.id = this.inFromBus.readLong();
                this.agentVersion = this.inFromBus.readUTF();
                if (this.id < 0L) {
                    throw new IllegalArgumentException("Invalid client");
                }
            } else {
                if (ok == 258) {
                    this.agentVersion = this.inFromBus.readUTF();
                    int errorCode = this.inFromBus.readInt();
                    byte[] msg = NTalkUtils.readArray(this.inFromBus);
                    throw new IllegalArgumentException("unable to connect client: error " + NTalkConstants.errorCode(errorCode) + " : " + new String(msg));
                }
                throw new IllegalArgumentException("unable to connect client: invalid response");
            }
            this.challenge = this.inFromBus.readUTF();
            this.connected = true;
            this.log("CONNECT: handshake ok");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public synchronized byte[] request(String service, byte[] requestMessage) {
        try {
            this.log("REQUEST:send " + service);
            this.outToBus.writeInt(11);
            this.outToBus.writeUTF(service);
            NTalkUtils.writeArray(requestMessage, this.outToBus);
            this.log("REQUEST:receive " + service);
            int ok = this.inFromBus.readInt();
            if (ok == 12 || ok == 13) {
                long jobId = this.inFromBus.readLong();
                String srv = this.inFromBus.readUTF();
                if (ok == 12) {
                    byte[] msg = NTalkUtils.readArray(this.inFromBus);
                    this.log("REQUEST:OK " + service);
                    return msg;
                }
                int errorCode = this.inFromBus.readInt();
                byte[] msg = NTalkUtils.readArray(this.inFromBus);
                this.log("REQUEST:KO " + service);
                throw new IllegalArgumentException("unable to send request: error " + NTalkConstants.errorCode(errorCode) + " : " + new String(msg));
            }
            throw new IllegalArgumentException("unable to send request: invalid response");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.outToBus.writeInt(255);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.inFromBus != null) {
                    this.inFromBus.close();
                    this.inFromBus = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.outToBus != null) {
                    this.outToBus.close();
                    this.outToBus = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void log(String msg) {
    }
}

