/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.nanodb;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDB;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBDefaultInputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBDefaultOutputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBSerializer;

public class NanoDBTableFile<T>
implements Iterable<T>,
AutoCloseable {
    public static final String NANODB_TABLE_0_8_1 = "nanodb-table-0.8.1";
    private final Object tableLock = new Object();
    private NanoDBSerializer<T> serializer;
    private Map<String, IndexInfo> indexDefinitions = new HashMap<String, IndexInfo>();
    private File dir;
    private String tableName;
    private NanoDBOutputStream writeStream;
    private NanoDBInputStream readStream;
    private FileChannel readChannel;
    private NanoDB db;

    public NanoDBTableFile(File dir, String tableName, NanoDBSerializer<T> serializer, NanoDB db, NanoDBIndexDefinition<T>[] indexDefinitions) {
        this.dir = dir;
        this.db = db;
        this.tableName = tableName;
        this.serializer = serializer;
        for (NanoDBIndexDefinition<T> indexDefinition : indexDefinitions) {
            this.indexDefinitions.put(indexDefinition.getIndexName(), new IndexInfo(indexDefinition));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long position) {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.readStream == null) {
                try {
                    FileInputStream readStreamFIS = new FileInputStream(this.getTableFile());
                    this.readChannel = readStreamFIS.getChannel();
                    this.readStream = new NanoDBDefaultInputStream(readStreamFIS);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try {
                this.readChannel.position(position);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this.serializer.read(this.readStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(T a) {
        Object object = this.tableLock;
        synchronized (object) {
            File tableFile = this.getTableFile();
            boolean writeHeader = false;
            long len = 0L;
            if (!tableFile.exists() || tableFile.length() == 0L) {
                writeHeader = true;
            } else {
                len = tableFile.length();
            }
            if (this.writeStream == null) {
                try {
                    this.writeStream = new NanoDBDefaultOutputStream(new FileOutputStream(tableFile, true));
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (writeHeader) {
                this.writeStream.writeUTF(NANODB_TABLE_0_8_1);
                this.writeStream.flush();
                len = this.writeStream.getPosition();
            }
            this.serializer.write(a, this.writeStream);
            this.updateIndices(a, len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.writeStream != null) {
                this.writeStream.flush();
            }
            for (IndexInfo value : this.indexDefinitions.values()) {
                value.flushIfDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.tableLock;
        synchronized (object) {
            this.flush();
            if (this.writeStream != null) {
                this.writeStream.flush();
                this.writeStream.close();
                this.writeStream = null;
            }
            if (this.readStream != null) {
                this.readStream.close();
                this.readStream = null;
            }
            if (this.readChannel != null) {
                this.readChannel = null;
            }
        }
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T nextValue;
            private NanoDBInputStream is;
            private boolean closed;
            private String header;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.closed) {
                    return false;
                }
                Object object = NanoDBTableFile.this.tableLock;
                synchronized (object) {
                    if (this.is == null && NanoDBTableFile.this.getTableFile().exists()) {
                        try {
                            this.is = new NanoDBDefaultInputStream(new FileInputStream(NanoDBTableFile.this.getTableFile()));
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                        this.header = this.is.readUTF();
                    }
                    if (this.is != null) {
                        try {
                            this.nextValue = NanoDBTableFile.this.serializer.read(this.is);
                            return this.nextValue != null;
                        }
                        catch (Exception ex) {
                            try {
                                this.is.close();
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                this.is = null;
                                this.closed = true;
                            }
                            if (ex instanceof UncheckedIOException && ex.getCause() instanceof EOFException) {
                                return false;
                            }
                            if (ex instanceof RuntimeException) {
                                throw (RuntimeException)ex;
                            }
                            if (ex instanceof IOException) {
                                throw new UncheckedIOException((IOException)ex);
                            }
                            throw new RuntimeException(ex);
                        }
                    }
                    return false;
                }
            }

            @Override
            public T next() {
                return this.nextValue;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndices(T a, long objectId) {
        Object object = this.tableLock;
        synchronized (object) {
            for (IndexInfo value : this.indexDefinitions.values()) {
                NanoDBIndex fi = value.getData();
                fi.put(value.getDefinition().getIndexedValue(a), objectId);
                value.dirty = true;
            }
        }
    }

    private File getTableFile() {
        return new File(this.dir, this.tableName + ".table");
    }

    public Stream<T> findByIndex(String indexName, Object value) {
        return this.resolveIndexInfo(indexName).getData().get(value).mapToObj(pos -> this.get(pos));
    }

    public <T> Stream<T> findIndexValues(String indexName) {
        return this.resolveIndexInfo(indexName).getData().findAll();
    }

    public long getFileLength() {
        return this.getTableFile().length();
    }

    public static int getUTFLength(String s) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        int init = 0;
        try {
            DataOutputStream r = new DataOutputStream(o);
            r.flush();
            init = o.toByteArray().length;
            r.writeUTF(s);
            r.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return o.toByteArray().length - init;
    }

    private IndexInfo resolveIndexInfo(String name) {
        IndexInfo y = this.indexDefinitions.get(name);
        if (y == null) {
            throw new IllegalArgumentException("not found index: " + name);
        }
        return y;
    }

    private class IndexInfo {
        NanoDBIndexDefinition def;
        NanoDBIndex data;
        boolean dirty;

        public IndexInfo(NanoDBIndexDefinition def) {
            this.def = def;
        }

        public NanoDBIndexDefinition getDefinition() {
            return this.def;
        }

        public void flushIfDirty() {
            if (this.dirty) {
                this.flush();
                this.dirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = NanoDBTableFile.this.tableLock;
            synchronized (object) {
                this.data.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoDBIndex getData() {
            Object object = NanoDBTableFile.this.tableLock;
            synchronized (object) {
                if (this.data != null) {
                    return this.data;
                }
                NanoDBIndex fi = NanoDBTableFile.this.db.createIndexFor(NanoDBTableFile.this.db.getSerializers().findSerializer(this.def.getIndexType(), this.def.isNullable()), this.getIndexFile());
                fi.load();
                this.data = fi;
                return fi;
            }
        }

        private File getIndexFile() {
            return new File(NanoDBTableFile.this.dir, NanoDBTableFile.this.tableName + "." + this.getIndexName() + ".index");
        }

        private String getIndexName() {
            return this.def.getIndexName();
        }
    }
}

