/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.mvn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.bundles.mvn.Pom;
import net.thevpc.nuts.runtime.bundles.mvn.PomDependency;
import net.thevpc.nuts.runtime.bundles.mvn.PomDomVisitor;
import net.thevpc.nuts.runtime.bundles.mvn.PomId;
import net.thevpc.nuts.runtime.bundles.mvn.PomLogger;
import net.thevpc.nuts.runtime.bundles.mvn.PomRepository;
import net.thevpc.nuts.runtime.bundles.mvn.PomRepositoryPolicy;
import net.thevpc.nuts.runtime.core.format.xml.NutsXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomXmlParser {
    private static Map<String, String> map = new HashMap<String, String>();
    private static Pattern ENTITY_PATTERN = Pattern.compile("&[a-zA-Z]+;");
    private PomLogger logger;

    public PomXmlParser(PomLogger logger) {
        this.logger = logger == null ? PomLogger.DEFAULT : logger;
    }

    public Pom parse(URL url, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(url, null, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pom parse(URL url, PomDomVisitor visitor, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        try (InputStream is = null;){
            is = url.openStream();
            Pom pom = this.parse(is, visitor, session);
            return pom;
        }
    }

    public Pom parse(URI uri, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(uri, null, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pom parse(URI uri, PomDomVisitor visitor, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        try (InputStream is = null;){
            is = uri.toURL().openStream();
            Pom pom = this.parse(is, session);
            return pom;
        }
    }

    public Pom parse(File file, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(file, null, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pom parse(File file, PomDomVisitor visitor, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        try (InputStream is = null;){
            Pom pom = this.parse(new FileInputStream(file), session);
            return pom;
        }
    }

    public Pom parse(InputStream stream, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(stream, null, session);
    }

    public Pom parse(InputStream stream, PomDomVisitor visitor, NutsSession session) throws IOException, SAXException, ParserConfigurationException {
        Document doc = NutsXmlUtils.createDocumentBuilder(true, session).parse(this.preValidateStream(stream, session));
        return this.parse(doc, visitor);
    }

    private byte[] loadAllBytes(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        int size = in.available();
        if (size <= 4096) {
            size = 4096;
        }
        byte[] b = new byte[size];
        while ((count = in.read(b)) > 0) {
            o.write(b, 0, count);
        }
        return o.toByteArray();
    }

    private InputStream preValidateStream(InputStream in, NutsSession session) throws IOException {
        int skip;
        byte[] bytes0 = this.loadAllBytes(in);
        for (skip = 0; skip < bytes0.length && Character.isWhitespace(bytes0[skip]); ++skip) {
        }
        String x = new String(bytes0, skip, bytes0.length - skip);
        StringBuffer sb = new StringBuffer();
        Matcher m = ENTITY_PATTERN.matcher(x);
        while (m.find()) {
            String key = m.group();
            String v = map.get(key);
            if (v != null) {
                m.appendReplacement(sb, v);
                continue;
            }
            this.logger.log(Level.WARNING, "[PomXmlParser] unsupported  xml entity declaration : {0}", key);
            m.appendReplacement(sb, key);
        }
        m.appendTail(sb);
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public Pom parse(Document doc) {
        return this.parse(doc, null);
    }

    public Pom parse(Document doc, PomDomVisitor visitor) {
        ArrayList<PomDependency> deps = new ArrayList<PomDependency>();
        ArrayList<PomDependency> depsMan = new ArrayList<PomDependency>();
        ArrayList<PomRepository> repos = new ArrayList<PomRepository>();
        ArrayList<PomRepository> pluginRepos = new ArrayList<PomRepository>();
        doc.getDocumentElement().normalize();
        NodeList rootChildList = doc.getDocumentElement().getChildNodes();
        String groupId = "";
        String inceptionYear = "";
        String url = "";
        String artifactId = "";
        String description = "";
        String name = "";
        ArrayList<String> modules = new ArrayList<String>();
        String version = "";
        String packaging = "";
        PomId parentId = null;
        if (visitor != null) {
            visitor.visitStartDocument(doc);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        block44: for (int i = 0; i < rootChildList.getLength(); ++i) {
            Element elem1 = PomXmlParser.toElement(rootChildList.item(i));
            if (elem1 == null) continue;
            switch (elem1.getTagName()) {
                case "groupId": {
                    groupId = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "artifactId": {
                    artifactId = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "version": {
                    version = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "packaging": {
                    packaging = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "description": {
                    description = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "name": {
                    name = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "inceptionYear": {
                    inceptionYear = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "url": {
                    url = PomXmlParser.elemToStr(elem1);
                    continue block44;
                }
                case "parent": {
                    NodeList parentChildList = elem1.getChildNodes();
                    String p_groupId = "";
                    String p_artifactId = "";
                    String p_version = "";
                    block45: for (int j = 0; j < parentChildList.getLength(); ++j) {
                        Element parElem = PomXmlParser.toElement(parentChildList.item(j));
                        if (parElem == null) continue;
                        switch (parElem.getTagName()) {
                            case "groupId": {
                                p_groupId = PomXmlParser.elemToStr(parElem);
                                continue block45;
                            }
                            case "artifactId": {
                                p_artifactId = PomXmlParser.elemToStr(parElem);
                                continue block45;
                            }
                            case "version": {
                                p_version = PomXmlParser.elemToStr(parElem);
                            }
                        }
                    }
                    if (p_groupId.length() <= 0 && p_artifactId.length() <= 0 && p_version.length() <= 0) continue block44;
                    parentId = new PomId(p_groupId, p_artifactId, p_version);
                    continue block44;
                }
                case "modules": {
                    NodeList childList = elem1.getChildNodes();
                    for (int j = 0; j < childList.getLength(); ++j) {
                        String s;
                        Element parElem = PomXmlParser.toElement(childList.item(j), "module");
                        if (parElem == null || (s = PomXmlParser.elemToStr(parElem)).isEmpty()) continue;
                        modules.add(s);
                    }
                    continue block44;
                }
                case "properties": {
                    if (visitor != null) {
                        visitor.visitStartProperties(elem1);
                    }
                    props = PomXmlParser.parseProperties(elem1);
                    if (visitor == null) continue block44;
                    visitor.visitEndProperties(elem1, props);
                    continue block44;
                }
                case "dependencyManagement": {
                    if (visitor != null) {
                        visitor.visitStartDependenciesManagement(elem1);
                    }
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        Element dependencies = PomXmlParser.toElement(dependenciesChildList.item(j), "dependencies");
                        if (dependencies == null) continue;
                        NodeList dependenciesChildList2 = dependencies.getChildNodes();
                        for (int k = 0; k < dependenciesChildList2.getLength(); ++k) {
                            Element dependency2 = PomXmlParser.toElement(dependenciesChildList2.item(k), "dependency");
                            if (dependency2 == null) continue;
                            if (visitor != null) {
                                visitor.visitStartDependencyManagement(dependency2);
                            }
                            PomDependency dep = PomXmlParser.parseDependency(dependency2, props);
                            if (visitor != null) {
                                visitor.visitEndDependencyManagement(dependency2, dep);
                            }
                            depsMan.add(dep);
                        }
                    }
                    if (visitor == null) continue block44;
                    visitor.visitEndDependenciesManagement(elem1, deps.toArray(new PomDependency[0]));
                    continue block44;
                }
                case "dependencies": {
                    if (visitor != null) {
                        visitor.visitStartDependencies(elem1);
                    }
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        Element dependency = PomXmlParser.toElement(dependenciesChildList.item(j), "dependency");
                        if (dependency == null) continue;
                        if (visitor != null) {
                            visitor.visitStartDependency(dependency);
                        }
                        PomDependency dep = PomXmlParser.parseDependency(dependency, props);
                        if (visitor != null) {
                            visitor.visitEndDependency(dependency, dep);
                        }
                        deps.add(dep);
                    }
                    if (visitor == null) continue block44;
                    visitor.visitEndDependencies(elem1, deps.toArray(new PomDependency[0]));
                    continue block44;
                }
                case "repositories": {
                    PomRepository repo;
                    Element repository;
                    if (visitor != null) {
                        visitor.visitStartRepositories(elem1);
                    }
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        repository = PomXmlParser.toElement(dependenciesChildList.item(j), "repository");
                        if (repository == null) continue;
                        if (visitor != null) {
                            visitor.visitStartRepository(repository);
                        }
                        repo = PomXmlParser.parseRepository(repository);
                        if (visitor != null) {
                            visitor.visitEndRepository(repository, repo);
                        }
                        repos.add(repo);
                    }
                    if (visitor == null) continue block44;
                    visitor.visitEndRepositories(elem1, repos.toArray(new PomRepository[0]));
                    continue block44;
                }
                case "pluginRepositories": {
                    PomRepository repo;
                    Element repository;
                    if (visitor != null) {
                        visitor.visitStartPluginRepositories(elem1);
                    }
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        repository = PomXmlParser.toElement(dependenciesChildList.item(j), "pluginRepository");
                        if (repository == null) continue;
                        if (visitor != null) {
                            visitor.visitStartPluginRepository(repository);
                        }
                        repo = PomXmlParser.parseRepository(repository);
                        if (visitor != null) {
                            visitor.visitEndPluginRepository(repository, repo);
                        }
                        pluginRepos.add(repo);
                    }
                    if (visitor == null) continue block44;
                    visitor.visitEndPluginRepositories(elem1, pluginRepos.toArray(new PomRepository[0]));
                    continue block44;
                }
            }
        }
        Pom pom = new Pom(groupId, artifactId, version, packaging, parentId, name, description, url, inceptionYear, props, deps.toArray(new PomDependency[0]), depsMan.toArray(new PomDependency[0]), repos.toArray(new PomRepository[0]), pluginRepos.toArray(new PomRepository[0]), modules.toArray(new String[0]), doc);
        if (visitor != null) {
            visitor.visitEndDocument(doc, pom);
        }
        return pom;
    }

    private static String elemToStr(Element ex) {
        return ex.getTextContent() == null ? "" : ex.getTextContent().trim();
    }

    private static Element toElement(Node n) {
        if (n instanceof Element) {
            return (Element)n;
        }
        return null;
    }

    private static Element toElement(Node n, String name) {
        if (n instanceof Element && ((Element)n).getTagName().equals(name)) {
            return (Element)n;
        }
        return null;
    }

    public static Map<String, String> parseProperties(Element properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        NodeList propsChildList = properties.getChildNodes();
        for (int j = 0; j < propsChildList.getLength(); ++j) {
            Element parElem = PomXmlParser.toElement(propsChildList.item(j));
            if (parElem == null) continue;
            props.put(parElem.getTagName(), PomXmlParser.elemToStr(parElem));
        }
        return props;
    }

    public static PomDependency parseDependency(Element dependency, Map<String, String> props) {
        NodeList dependencyChildList = dependency.getChildNodes();
        String d_groupId = "";
        String d_artifactId = "";
        String d_version = "";
        String d_classifier = "";
        String d_scope = "";
        String d_optional = "";
        String d_type = "";
        ArrayList<PomId> d_exclusions = new ArrayList<PomId>();
        block28: for (int k = 0; k < dependencyChildList.getLength(); ++k) {
            Element c = PomXmlParser.toElement(dependencyChildList.item(k));
            if (c == null) continue;
            switch (c.getTagName()) {
                case "groupId": {
                    d_groupId = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "artifactId": {
                    d_artifactId = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "classifier": {
                    d_classifier = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "version": {
                    d_version = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "scope": {
                    d_scope = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "optional": {
                    d_optional = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "type": {
                    d_type = PomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "exclusions": {
                    NodeList exclusionsList = c.getChildNodes();
                    for (int l = 0; l < exclusionsList.getLength(); ++l) {
                        Element ex = PomXmlParser.toElement(exclusionsList.item(l), "exclusion");
                        if (ex == null) continue;
                        String ex_groupId = "";
                        String ex_artifactId = "";
                        NodeList exclusionsList2 = ex.getChildNodes();
                        block30: for (int m = 0; m < exclusionsList2.getLength(); ++m) {
                            Element ex2 = PomXmlParser.toElement(exclusionsList2.item(m));
                            if (ex2 == null) continue;
                            switch (ex2.getTagName()) {
                                case "groupId": {
                                    ex_groupId = PomXmlParser.elemToStr(ex2);
                                    continue block30;
                                }
                                case "artifactId": {
                                    ex_artifactId = PomXmlParser.elemToStr(ex2);
                                }
                            }
                        }
                        if (ex_groupId.isEmpty()) continue;
                        d_exclusions.add(new PomId(ex_groupId, ex_artifactId, null));
                    }
                    continue block28;
                }
            }
        }
        if (d_scope.isEmpty()) {
            d_scope = "compile";
        }
        return new PomDependency(d_groupId, d_artifactId, d_classifier, d_version, d_scope, d_optional, props == null ? null : props.get("dependencies." + d_groupId + ":" + d_artifactId + ".os"), props == null ? null : props.get("dependencies." + d_groupId + ":" + d_artifactId + ".arch"), d_type, d_exclusions.toArray(new PomId[0]));
    }

    public static PomRepositoryPolicy parseRepositoryPolicy(Element dependency) {
        NodeList childList = dependency.getChildNodes();
        String enabled = "";
        String updatePolicy = "";
        String checksumPolicy = "";
        block10: for (int k = 0; k < childList.getLength(); ++k) {
            Element c = PomXmlParser.toElement(childList.item(k));
            if (c == null) continue;
            switch (c.getTagName()) {
                case "enabled": {
                    enabled = PomXmlParser.elemToStr(c);
                    continue block10;
                }
                case "updatePolicy": {
                    updatePolicy = PomXmlParser.elemToStr(c);
                    continue block10;
                }
                case "checksumPolicy": {
                    checksumPolicy = PomXmlParser.elemToStr(c);
                }
            }
        }
        return new PomRepositoryPolicy(enabled.isEmpty() || Boolean.parseBoolean(enabled), updatePolicy, checksumPolicy);
    }

    public static PomRepository parseRepository(Element repository) {
        NodeList childList = repository.getChildNodes();
        String id = "";
        String layout = "";
        String url = "";
        String name = "";
        PomRepositoryPolicy snapshots = null;
        PomRepositoryPolicy releases = null;
        block16: for (int k = 0; k < childList.getLength(); ++k) {
            Element c = PomXmlParser.toElement(childList.item(k));
            if (c == null) continue;
            switch (c.getTagName()) {
                case "id": {
                    id = PomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "layout": {
                    layout = PomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "url": {
                    url = PomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "name": {
                    name = PomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "snapshots": {
                    snapshots = PomXmlParser.parseRepositoryPolicy(c);
                    continue block16;
                }
                case "releases": {
                    releases = PomXmlParser.parseRepositoryPolicy(c);
                }
            }
        }
        if (name.isEmpty()) {
            name = "compile";
        }
        return new PomRepository(id, layout, url, name, releases, snapshots);
    }

    public static Element createExclusionElement(Document doc, PomId exclusionId) {
        Element e = doc.createElement("exclusion");
        e.appendChild(PomXmlParser.createNameTextTag(doc, "groupId", exclusionId.getGroupId()));
        e.appendChild(PomXmlParser.createNameTextTag(doc, "artifactId", exclusionId.getArtifactId()));
        if (exclusionId.getVersion() != null && exclusionId.getVersion().trim().length() > 0) {
            e.appendChild(PomXmlParser.createNameTextTag(doc, "version", exclusionId.getVersion()));
        }
        return e;
    }

    public static Element createDependencyElement(Document doc, PomDependency dep) {
        PomId[] e;
        Element dependency = doc.createElement("dependency");
        dependency.appendChild(PomXmlParser.createNameTextTag(doc, "groupId", dep.getGroupId()));
        dependency.appendChild(PomXmlParser.createNameTextTag(doc, "artifactId", dep.getArtifactId()));
        if (dep.getVersion() != null && dep.getVersion().trim().length() > 0) {
            dependency.appendChild(PomXmlParser.createNameTextTag(doc, "version", dep.getVersion()));
        }
        if (dep.getOptional() != null && dep.getOptional().trim().length() > 0) {
            dependency.appendChild(PomXmlParser.createNameTextTag(doc, "optional", dep.getOptional()));
        }
        if (dep.getType() != null && dep.getType().trim().length() > 0) {
            dependency.appendChild(PomXmlParser.createNameTextTag(doc, "type", dep.getType()));
        }
        if ((e = dep.getExclusions()).length > 0) {
            Element exclusions = doc.createElement("exclusions");
            dependency.appendChild(exclusions);
            for (PomId pomId : e) {
                exclusions.appendChild(PomXmlParser.createExclusionElement(doc, pomId));
            }
        }
        return dependency;
    }

    public static Element createRepositoryElement(Document doc, PomRepository repo) {
        return PomXmlParser.createRepositoryElement(doc, repo, "repository");
    }

    public static Element createPluginRepositoryElement(Document doc, PomRepository repo) {
        return PomXmlParser.createRepositoryElement(doc, repo, "pluginRepository");
    }

    public static Element createRepositoryPolicy(Document doc, PomRepositoryPolicy repo, String name) {
        Element snapshots = doc.createElement(name);
        snapshots.appendChild(PomXmlParser.createNameTextTag(doc, "enabled", String.valueOf(repo.isEnabled())));
        if (repo.getUpdatePolicy() != null && repo.getUpdatePolicy().trim().length() > 0) {
            snapshots.appendChild(PomXmlParser.createNameTextTag(doc, "updatePolicy", repo.getUpdatePolicy()));
        }
        if (repo.getChecksumPolicy() != null && repo.getChecksumPolicy().trim().length() > 0) {
            snapshots.appendChild(PomXmlParser.createNameTextTag(doc, "checksumPolicy", repo.getChecksumPolicy()));
        }
        return snapshots;
    }

    public static Element createNameTextTag(Document doc, String name, String value) {
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(value));
        return elem;
    }

    public static Element createRepositoryElement(Document doc, PomRepository repo, String name) {
        Element repository = doc.createElement(name);
        repository.appendChild(PomXmlParser.createNameTextTag(doc, "id", repo.getId()));
        repository.appendChild(PomXmlParser.createNameTextTag(doc, "url", repo.getUrl()));
        if (repo.getLayout() != null && repo.getLayout().trim().length() > 0) {
            repository.appendChild(PomXmlParser.createNameTextTag(doc, "layout", repo.getLayout()));
        }
        if (repo.getName() != null && repo.getName().trim().length() > 0) {
            repository.appendChild(PomXmlParser.createNameTextTag(doc, "name", repo.getName()));
        }
        if (repo.getSnapshots() != null) {
            repository.appendChild(PomXmlParser.createRepositoryPolicy(doc, repo.getSnapshots(), "snapshots"));
        }
        if (repo.getReleases() != null) {
            repository.appendChild(PomXmlParser.createRepositoryPolicy(doc, repo.getReleases(), "releases"));
        }
        return repository;
    }

    public static void writeDocument(Document doc, File result, NutsSession session) throws TransformerException {
        PomXmlParser.writeDocument(doc, new StreamResult(result), session);
    }

    public static void writeDocument(Document doc, Writer result, NutsSession session) throws TransformerException {
        PomXmlParser.writeDocument(doc, new StreamResult(result), session);
    }

    public static void writeDocument(Document doc, OutputStream result, NutsSession session) throws TransformerException {
        PomXmlParser.writeDocument(doc, new StreamResult(result), session);
    }

    public static void writeDocument(Document doc, StreamResult result, NutsSession session) throws TransformerException {
        NutsXmlUtils.writeDocument(doc, result, false, true, session);
    }

    public static boolean appendOrReplaceDependency(PomDependency dependency, Element dependencyElement, Element dependenciesElement, Map<String, String> props) {
        if (dependencyElement != null && dependenciesElement == null) {
            dependenciesElement = (Element)dependencyElement.getParentNode();
        }
        Document doc = dependenciesElement.getOwnerDocument();
        if (dependencyElement == null) {
            dependenciesElement.appendChild(PomXmlParser.createDependencyElement(doc, dependency));
            return true;
        }
        PomDependency old = PomXmlParser.parseDependency(dependencyElement, props);
        if (old == null || !old.equals(dependency)) {
            dependenciesElement.replaceChild(PomXmlParser.createDependencyElement(doc, dependency), dependencyElement);
            return true;
        }
        return false;
    }

    public static boolean appendOrReplaceRepository(PomRepository repository, Element repositoryElement, Element repositoriesElement) {
        if (repositoryElement != null && repositoriesElement == null) {
            repositoriesElement = (Element)repositoryElement.getParentNode();
        }
        Document doc = repositoriesElement.getOwnerDocument();
        if (repositoryElement == null) {
            repositoriesElement.appendChild(PomXmlParser.createRepositoryElement(doc, repository));
            return true;
        }
        PomRepository old = PomXmlParser.parseRepository(repositoryElement);
        if (old == null || !old.equals(repository)) {
            repositoriesElement.replaceChild(PomXmlParser.createRepositoryElement(doc, repository), repositoryElement);
            return true;
        }
        return false;
    }

    static {
        map.put("&Oslash;", "&#216;");
        map.put("&oslash;", "&#248;");
        map.put("&AElig;", "&#198;");
        map.put("&aelig;", "&#230;");
        map.put("&Auml;", "&#196;");
        map.put("&auml;", "&#228;");
        map.put("&OElig;", "&#338;");
        map.put("&oelig;", "&#339;");
        map.put("&lt;", "&#60;");
        map.put("&gt;", "&#62;");
        map.put("&amp;", "&#38;");
        map.put("&quot;", "&#34;");
        map.put("&euro;", "&#8364;");
        map.put("&circ;", "&#710;");
        map.put("&tilde;", "&#732;");
        map.put("&ndash;", "&#45;");
        map.put("&copy;", "&#169;");
        map.put("&nbsp;", "&#32;");
        map.put("&apos;", "&#39;");
    }
}

