/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;

public class LazyIterator<T>
implements Iterator<T> {
    private Iterable<T> iterable;
    private Iterator<T> iterator;

    public LazyIterator() {
    }

    public LazyIterator(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.iterable == null ? this.iterator() : this.iterable.iterator();
            if (this.iterator == null) {
                return false;
            }
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    protected Iterator<T> iterator() {
        throw new UnsupportedOperationException("no implemented");
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public String toString() {
        return "LazyIterator(" + (this.iterator != null ? this.iterator.toString() : (this.iterable != null ? this.iterable.toString() : "null")) + ")";
    }
}

