/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsIndexerNotAccessibleException;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class IndexFirstIterator<T>
implements Iterator<T> {
    private static Logger LOG = Logger.getLogger(IndexFirstIterator.class.getName());
    private Iterator<T> index;
    private Iterator<T> other;
    private long readFromIndex;
    private T nextItem;
    private boolean hasNextItem;

    public IndexFirstIterator(Iterator<T> index, Iterator<T> other) {
        this.index = index;
        this.other = other;
    }

    @Override
    public boolean hasNext() {
        if (this.index != null) {
            if (this.readFromIndex == 0L) {
                try {
                    boolean v = this.index.hasNext();
                    if (v) {
                        this.hasNextItem = true;
                        this.nextItem = this.index.next();
                        ++this.readFromIndex;
                    }
                    return v;
                }
                catch (NutsIndexerNotAccessibleException ex) {
                    this.index = null;
                }
            } else {
                try {
                    if (this.index.hasNext()) {
                        return true;
                    }
                    this.index = null;
                }
                catch (NutsIndexerNotAccessibleException ex) {
                    LOG.log(Level.SEVERE, "error evaluating Iterator 'hasNext()' : " + CoreStringUtils.exceptionToString(ex), ex);
                    this.other = null;
                    return false;
                }
            }
        }
        if (this.other != null) {
            return this.other.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNextItem) {
            this.hasNextItem = false;
            T t = this.nextItem;
            this.nextItem = null;
            return t;
        }
        if (this.index != null) {
            return this.index.next();
        }
        return this.other.next();
    }

    @Override
    public void remove() {
        if (this.index != null) {
            this.index.remove();
        } else if (this.other != null) {
            this.other.remove();
        }
    }

    public String toString() {
        return "IndexFirstIterator(" + this.other + ")";
    }
}

