/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.runtime.bundles.iter.IteratorErrorHandlerType;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class ErrorHandlerIterator<T>
implements Iterator<T> {
    private static Logger LOG = Logger.getLogger(ErrorHandlerIterator.class.getName());
    private IteratorErrorHandlerType type;
    private Iterator<T> other;
    private RuntimeException ex;

    public ErrorHandlerIterator(IteratorErrorHandlerType type, Iterator<T> other) {
        this.other = other;
        this.type = type;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean v = this.other.hasNext();
            this.ex = null;
            return v;
        }
        catch (RuntimeException ex) {
            LOG.log(Level.SEVERE, "error evaluating Iterator 'hasNext()' : " + CoreStringUtils.exceptionToString(ex), ex);
            switch (this.type) {
                case IGNORE: {
                    return false;
                }
                case POSPONE: {
                    this.ex = ex;
                    return true;
                }
                case THROW: {
                    throw ex;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public T next() {
        if (this.ex != null) {
            throw this.ex;
        }
        return this.other.next();
    }

    @Override
    public void remove() {
        if (this.ex != null) {
            throw this.ex;
        }
        this.other.remove();
    }

    public String toString() {
        switch (this.type) {
            case THROW: {
                return "ThrowOnError(" + this.other + ")";
            }
            case POSPONE: {
                return "PostponeError(" + this.other + ")";
            }
            case IGNORE: {
                return "IgnoreError(" + this.other + ")";
            }
        }
        return "ErrorHandlerIterator(type=" + (Object)((Object)this.type) + ", base=" + this.other + ')';
    }
}

