/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class ConvertedToListIterator<F, T>
implements Iterator<T> {
    private final Iterator<F> base;
    private final Function<F, List<T>> converter;
    private final LinkedList<T> current = new LinkedList();

    public ConvertedToListIterator(Iterator<F> base, Function<F, List<T>> converter) {
        this.base = base;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        if (!this.current.isEmpty()) {
            return true;
        }
        while (this.base.hasNext()) {
            F f = this.base.next();
            List<T> c = this.converter.apply(f);
            this.current.addAll(c);
            if (this.current.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        return this.current.poll();
    }

    @Override
    public void remove() {
        this.base.remove();
    }
}

