/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.function.Function;

public class ConvertedNonNullIterator<F, T>
implements Iterator<T> {
    private final Iterator<F> base;
    private final Function<F, T> converter;
    private final String convertName;
    private T lastVal;

    public ConvertedNonNullIterator(Iterator<F> base, Function<F, T> converter, String convertName) {
        this.base = base;
        this.converter = converter;
        if (convertName == null) {
            convertName = this.converter.toString();
        }
        this.convertName = convertName;
    }

    @Override
    public boolean hasNext() {
        while (this.base.hasNext()) {
            F i = this.base.next();
            if (i == null) continue;
            this.lastVal = this.converter.apply(i);
            if (this.lastVal == null) continue;
            break;
        }
        return this.lastVal != null;
    }

    @Override
    public T next() {
        return this.lastVal;
    }

    @Override
    public void remove() {
        throw new IllegalArgumentException("Unsupported remove");
    }

    public String toString() {
        return "ConvertedNonNullIterator(" + this.base + "," + this.convertName + ")";
    }
}

