/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.function.Function;

public class ConvertedIterator<F, T>
implements Iterator<T> {
    private final Iterator<F> base;
    private final Function<F, T> converter;
    private final String convertName;

    public ConvertedIterator(Iterator<F> base, Function<F, T> converter, String convertName) {
        this.base = base;
        this.converter = converter;
        if (convertName == null) {
            convertName = this.converter.toString();
        }
        this.convertName = convertName;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public T next() {
        return this.converter.apply(this.base.next());
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public String toString() {
        return "ConvertedIterator(" + this.base + "," + this.convertName + ")";
    }
}

