/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.bundles.io.MultiPipeThread;
import net.thevpc.nuts.runtime.bundles.io.NonBlockingInputStream;
import net.thevpc.nuts.runtime.bundles.io.NonBlockingInputStreamAdapter;
import net.thevpc.nuts.runtime.bundles.io.PipeThread;
import net.thevpc.nuts.runtime.core.app.DefaultNutsArgument;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class ProcessBuilder2 {
    private List<String> command = new ArrayList<String>();
    private Map<String, String> env;
    private File directory;
    private ProcessBuilder base = new ProcessBuilder(new String[0]);
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private int result;
    private boolean baseIO;
    private boolean failFast;
    private Process proc;
    private long sleepMillis = 1000L;
    private NutsSession session;

    public ProcessBuilder2(NutsSession session) {
        this.session = session;
    }

    private static String formatArg(String s, NutsSession session) {
        DefaultNutsArgument a = new DefaultNutsArgument(s);
        StringBuilder sb = new StringBuilder();
        NutsTextManager factory = session.getWorkspace().text();
        if (a.isKeyValue()) {
            if (a.isOption()) {
                sb.append(factory.forStyled(CoreStringUtils.enforceDoubleQuote(a.getStringKey(), session), NutsTextStyle.option()));
                sb.append("=");
                sb.append(CoreStringUtils.enforceDoubleQuote(a.getStringValue(), session));
            } else {
                sb.append(factory.forStyled(CoreStringUtils.enforceDoubleQuote(a.getStringKey(), session), NutsTextStyle.primary4()));
                sb.append("=");
                sb.append(CoreStringUtils.enforceDoubleQuote(a.getStringValue(), session));
            }
        } else if (a.isOption()) {
            sb.append(factory.forStyled(CoreStringUtils.enforceDoubleQuote(a.getString(), session), NutsTextStyle.option()));
        } else {
            sb.append(CoreStringUtils.enforceDoubleQuote(a.getString(), session));
        }
        return sb.toString();
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public ProcessBuilder2 setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
        return this;
    }

    public Process getProc() {
        return this.proc;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public ProcessBuilder2 setCommand(String ... command) {
        this.setCommand(Arrays.asList(command));
        return this;
    }

    public ProcessBuilder2 setCommand(List<String> command) {
        this.command = command == null ? null : new ArrayList<String>(command);
        return this;
    }

    public ProcessBuilder2 addCommand(String ... command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.addAll(Arrays.asList(command));
        return this;
    }

    public ProcessBuilder2 addCommand(List<String> command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.addAll(command);
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public ProcessBuilder2 setEnv(Map<String, String> env) {
        this.env = env == null ? null : new HashMap<String, String>(env);
        return this;
    }

    public ProcessBuilder2 addEnv(Map<String, String> env) {
        if (env != null) {
            if (this.env == null) {
                this.env = new HashMap<String, String>(env);
            } else {
                this.env.putAll(env);
            }
        }
        return this;
    }

    public ProcessBuilder2 setEnv(String k, String val) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(k, val);
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public ProcessBuilder2 setDirectory(File directory) {
        this.directory = directory;
        this.base.directory(directory);
        return this;
    }

    public ProcessBuilder2 setRedirectFileOutput(File file) {
        this.base.redirectOutput(file);
        return this;
    }

    public ProcessBuilder2 setRedirectFileInput(File file) {
        this.base.redirectInput(file);
        return this;
    }

    public InputStream getIn() {
        return this.in;
    }

    public ProcessBuilder2 setIn(InputStream in) {
        if (this.baseIO) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"already used base IO redirection", (Object[])new Object[0]));
        }
        this.in = in;
        return this;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public ProcessBuilder2 grabOutputString() {
        this.setOutput(new SPrintStream());
        return this;
    }

    public ProcessBuilder2 grabErrorString() {
        this.setOutput(new SPrintStream());
        return this;
    }

    public String getOutputString() {
        PrintStream o = this.getOut();
        if (o instanceof SPrintStream) {
            return ((SPrintStream)o).getStringBuffer();
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"no buffer was configured; should call setOutString", (Object[])new Object[0]));
    }

    public String getErrorString() {
        if (this.base.redirectErrorStream()) {
            return this.getOutputString();
        }
        PrintStream o = this.getErr();
        if (o instanceof SPrintStream) {
            return ((SPrintStream)o).getStringBuffer();
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"no buffer was configured; should call setErrString", (Object[])new Object[0]));
    }

    public ProcessBuilder2 setOutput(PrintStream out) {
        if (this.baseIO) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"already used base IO redirection", (Object[])new Object[0]));
        }
        this.out = out;
        return this;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public ProcessBuilder2 setErr(PrintStream err) {
        if (this.baseIO) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"already used base IO redirection", (Object[])new Object[0]));
        }
        this.err = err;
        return this;
    }

    public ProcessBuilder2 start() throws IOException {
        if (this.proc != null) {
            throw new IOException("Already started");
        }
        this.base.command(this.command);
        if (this.env != null) {
            Map<String, String> environment = this.base.environment();
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) continue;
                if (v == null) {
                    v = "";
                }
                environment.put(k, v);
            }
        }
        this.proc = this.base.start();
        return this;
    }

    public ProcessBuilder2 waitFor() throws IOException {
        if (this.proc == null) {
            this.start();
        }
        if (this.proc == null) {
            throw new IOException("Not started");
        }
        if (!this.baseIO) {
            NonBlockingInputStreamAdapter termIn = null;
            ArrayList<PipeThread> pipes = new ArrayList<PipeThread>();
            String procString = this.proc.toString();
            if (this.out != null) {
                NonBlockingInputStreamAdapter procInput = new NonBlockingInputStreamAdapter("pipe-out-proc-" + procString, this.proc.getInputStream());
                pipes.add(this.pipe("pipe-out-proc-" + procString, procInput, this.out));
            }
            if (this.err != null) {
                NonBlockingInputStreamAdapter procError = new NonBlockingInputStreamAdapter("pipe-err-proc-" + procString, this.proc.getErrorStream());
                if (this.base.redirectErrorStream()) {
                    pipes.add(this.pipe("pipe-err-proc-" + procString, procError, this.out));
                } else {
                    pipes.add(this.pipe("pipe-err-proc-" + procString, procError, this.err));
                }
            }
            if (this.in != null) {
                termIn = new NonBlockingInputStreamAdapter("pipe-in-proc-" + procString, this.in);
                pipes.add(this.pipe("pipe-in-proc-" + procString, termIn, this.proc.getOutputStream()));
            }
            while (this.proc.isAlive()) {
                if (termIn != null && !termIn.hasMoreBytes() && termIn.available() == 0) {
                    termIn.close();
                }
                boolean allFinished = true;
                for (PipeThread pipe : pipes) {
                    if (!pipe.isStopped()) {
                        allFinished = false;
                        continue;
                    }
                    pipe.getOut().close();
                }
                if (allFinished) break;
                try {
                    Thread.sleep(this.sleepMillis);
                }
                catch (InterruptedException e) {
                    throw new IOException(CoreStringUtils.exceptionToString(e));
                }
            }
            this.proc.getInputStream().close();
            this.proc.getErrorStream().close();
            this.proc.getOutputStream().close();
            this.waitFor0();
            for (PipeThread pipe : pipes) {
                pipe.requestStop();
            }
        } else {
            this.waitFor0();
        }
        return this;
    }

    private void waitFor0() throws IOException {
        try {
            this.result = this.proc.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(CoreStringUtils.exceptionToString(e));
        }
        if (this.result != 0 && this.isFailFast()) {
            if (this.base.redirectErrorStream()) {
                if (this.isGrabOutputString()) {
                    throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"execution failed with code %d and message : %s", (Object[])new Object[]{this.result, this.getOutputString()}), this.result);
                }
            } else {
                if (this.isGrabErrorString()) {
                    throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"execution failed with code %d and message : %s", (Object[])new Object[]{this.result, this.getOutputString()}), this.result);
                }
                if (this.isGrabOutputString()) {
                    throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"execution failed with code %d and message : %s", (Object[])new Object[]{this.result, this.getOutputString()}), this.result);
                }
            }
            throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"execution failed with code %d", (Object[])new Object[]{this.result}), this.result);
        }
    }

    public boolean isGrabOutputString() {
        return !this.baseIO && this.out instanceof SPrintStream;
    }

    public boolean isGrabErrorString() {
        return !this.baseIO && this.err instanceof SPrintStream;
    }

    private ProcessBuilder2 waitFor2() throws IOException {
        if (this.proc == null) {
            this.start();
        }
        if (this.proc == null) {
            throw new IOException("Not started");
        }
        NonBlockingInputStreamAdapter procInput = null;
        NonBlockingInputStreamAdapter procError = null;
        NonBlockingInputStreamAdapter termIn = null;
        MultiPipeThread mp = new MultiPipeThread("pipe-out-proc-" + this.proc.toString());
        if (this.out != null) {
            procInput = new NonBlockingInputStreamAdapter("pipe-out-proc-" + this.proc.toString(), this.proc.getInputStream());
            mp.add("pipe-out-proc-" + this.proc.toString(), procInput, this.out);
        }
        if (!this.base.redirectErrorStream() && this.err != null) {
            procError = new NonBlockingInputStreamAdapter("pipe-err-proc-" + this.proc.toString(), this.proc.getErrorStream());
            mp.add("pipe-err-proc-" + this.proc.toString(), procError, this.err);
        }
        if (this.in != null) {
            termIn = new NonBlockingInputStreamAdapter("pipe-in-proc-" + this.proc.toString(), this.in);
            mp.add("pipe-in-proc-" + this.proc.toString(), termIn, this.proc.getOutputStream());
        }
        mp.start();
        while (this.proc.isAlive()) {
            if (termIn != null && !termIn.hasMoreBytes() && termIn.available() == 0) {
                termIn.close();
            }
            if (mp.isEmpty()) break;
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        this.proc.getInputStream().close();
        this.proc.getErrorStream().close();
        this.proc.getOutputStream().close();
        try {
            this.result = this.proc.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        mp.requestStop();
        return this;
    }

    public int getResult() {
        return this.result;
    }

    public Process getProcess() {
        return this.proc;
    }

    public ProcessBuilder2 inheritIO() {
        this.baseIO = true;
        this.base.inheritIO();
        return this;
    }

    public ProcessBuilder2 redirectInput(ProcessBuilder.Redirect source) {
        this.base.redirectInput(source);
        this.baseIO = true;
        return this;
    }

    public ProcessBuilder2 redirectOutput(ProcessBuilder.Redirect source) {
        this.base.redirectOutput(source);
        this.baseIO = true;
        return this;
    }

    public ProcessBuilder2 redirectInput(File source) {
        this.base.redirectInput(source);
        this.baseIO = true;
        return this;
    }

    public ProcessBuilder2 redirectOutput(File source) {
        this.base.redirectOutput(source);
        this.baseIO = true;
        return this;
    }

    public ProcessBuilder2 redirectError(File source) {
        this.base.redirectError(source);
        this.baseIO = true;
        return this;
    }

    public ProcessBuilder.Redirect getRedirectInput() {
        return this.base.redirectInput();
    }

    public ProcessBuilder.Redirect getRedirectOutput() {
        return this.base.redirectOutput();
    }

    public ProcessBuilder.Redirect getRedirectError() {
        return this.base.redirectError();
    }

    public boolean isRedirectErrorStream() {
        return this.base.redirectErrorStream();
    }

    public ProcessBuilder2 setRedirectErrorStream(boolean redirectErrorStream) {
        this.base.redirectErrorStream(redirectErrorStream);
        return this;
    }

    public ProcessBuilder2 setRedirectErrorStream() {
        return this.setRedirectErrorStream(true);
    }

    public String getCommandString() {
        return this.getCommandString(null);
    }

    public String getCommandString(CommandStringFormat f) {
        StringBuilder sb = new StringBuilder();
        if (this.env != null) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) {
                    k = "";
                }
                if (v == null) {
                    v = "";
                }
                if (f != null) {
                    String v2;
                    if (!f.acceptEnvName(k, v)) continue;
                    String k2 = f.replaceEnvName(k, v);
                    if (k2 != null) {
                        k = k2;
                    }
                    if ((v2 = f.replaceEnvValue(k, v)) != null) {
                        v = v2;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(CoreStringUtils.enforceDoubleQuote(k)).append("=").append(CoreStringUtils.enforceDoubleQuote(v));
            }
        }
        for (int i = 0; i < this.command.size(); ++i) {
            String s = this.command.get(i);
            if (f != null) {
                if (!f.acceptArgument(i, s)) continue;
                String k2 = f.replaceArgument(i, s);
                if (k2 != null) {
                    s = k2;
                }
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(CoreStringUtils.enforceDoubleQuote(s));
        }
        if (this.baseIO) {
            if (f == null || f.acceptRedirectOutput()) {
                ProcessBuilder.Redirect r = this.base.redirectOutput();
                if (null == r.type()) {
                    sb.append(" > ").append("{?}");
                } else {
                    switch (r.type()) {
                        case INHERIT: {
                            break;
                        }
                        case PIPE: {
                            break;
                        }
                        case WRITE: {
                            sb.append(" > ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                            break;
                        }
                        case APPEND: {
                            sb.append(" >> ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                            break;
                        }
                        default: {
                            sb.append(" > ").append("{?}");
                        }
                    }
                }
            }
            if (f == null || f.acceptRedirectError()) {
                if (this.base.redirectErrorStream()) {
                    sb.append(" 2>&1");
                } else if (f == null || f.acceptRedirectError()) {
                    ProcessBuilder.Redirect r = this.base.redirectError();
                    if (null == r.type()) {
                        sb.append(" 2> ").append("{?}");
                    } else {
                        switch (r.type()) {
                            case INHERIT: {
                                break;
                            }
                            case PIPE: {
                                break;
                            }
                            case WRITE: {
                                sb.append(" 2> ").append(r.file().getPath());
                                break;
                            }
                            case APPEND: {
                                sb.append(" 2>> ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                                break;
                            }
                            default: {
                                sb.append(" 2> ").append("{?}");
                            }
                        }
                    }
                }
            }
            if (f == null || f.acceptRedirectInput()) {
                ProcessBuilder.Redirect r = this.base.redirectInput();
                if (null == r.type()) {
                    sb.append(" < ").append("{?}");
                } else {
                    switch (r.type()) {
                        case INHERIT: {
                            break;
                        }
                        case PIPE: {
                            break;
                        }
                        case READ: {
                            sb.append(" < ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                            break;
                        }
                        default: {
                            sb.append(" < ").append("{?}");
                        }
                    }
                }
            }
        } else if (this.base.redirectErrorStream()) {
            if (this.out != null) {
                if (f == null || f.acceptRedirectOutput()) {
                    sb.append(" > ").append("{stream}");
                }
                if (f == null || f.acceptRedirectError()) {
                    sb.append(" 2>&1");
                }
            }
            if (this.in != null && (f == null || f.acceptRedirectInput())) {
                sb.append(" < ").append("{stream}");
            }
        } else {
            if (this.out != null && (f == null || f.acceptRedirectOutput())) {
                sb.append(" > ").append("{stream}");
            }
            if (this.err != null && (f == null || f.acceptRedirectError())) {
                sb.append(" 2> ").append("{stream}");
            }
            if (this.in != null && (f == null || f.acceptRedirectInput())) {
                sb.append(" < ").append("{stream}");
            }
        }
        return sb.toString();
    }

    public String getFormattedCommandString(NutsSession session) {
        return this.getFormattedCommandString(session, null);
    }

    private String escape(NutsSession session, String f) {
        return session.getWorkspace().text().forPlain(f).toString();
    }

    public String getFormattedCommandString(NutsSession session, CommandStringFormat f) {
        StringBuilder sb = new StringBuilder();
        File ff = this.getDirectory();
        if (ff == null) {
            ff = new File(".");
        }
        try {
            ff = ff.getCanonicalFile();
        }
        catch (Exception ex) {
            ff = ff.getAbsoluteFile();
        }
        sb.append("cwd=```error ").append(CoreStringUtils.enforceDoubleQuote(ff.getPath(), session)).append("```");
        if (this.env != null) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) {
                    k = "";
                }
                if (v == null) {
                    v = "";
                }
                if (f != null) {
                    String v2;
                    if (!f.acceptEnvName(k, v)) continue;
                    String k2 = f.replaceEnvName(k, v);
                    if (k2 != null) {
                        k = k2;
                    }
                    if ((v2 = f.replaceEnvValue(k, v)) != null) {
                        v = v2;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(session.getWorkspace().text().forStyled(CoreStringUtils.enforceDoubleQuote(k, session), NutsTextStyle.primary4())).append("=").append(CoreStringUtils.enforceDoubleQuote(v, session));
            }
        }
        boolean commandFirstTokenVisited = false;
        for (int i = 0; i < this.command.size(); ++i) {
            String s = this.command.get(i);
            if (f != null) {
                if (!f.acceptArgument(i, s)) continue;
                String k2 = f.replaceArgument(i, s);
                if (k2 != null) {
                    s = k2;
                }
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (!commandFirstTokenVisited) {
                commandFirstTokenVisited = true;
                sb.append("```error ").append(CoreStringUtils.enforceDoubleQuote(s, session)).append("```");
                continue;
            }
            sb.append(ProcessBuilder2.formatArg(s, session));
        }
        if (this.baseIO) {
            if (f == null || f.acceptRedirectOutput()) {
                ProcessBuilder.Redirect r = this.base.redirectOutput();
                if (null == r.type()) {
                    sb.append("##:separator:").append(this.escape(session, " > ")).append("## ").append("##:pale:{?}##");
                } else {
                    switch (r.type()) {
                        case INHERIT: {
                            break;
                        }
                        case PIPE: {
                            break;
                        }
                        case WRITE: {
                            sb.append("##:separator:").append(this.escape(session, " >")).append("## ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                            break;
                        }
                        case APPEND: {
                            sb.append("##:separator:").append(this.escape(session, " >>")).append("## ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                            break;
                        }
                        default: {
                            sb.append("##:separator:").append(this.escape(session, " >")).append("## ").append("##:pale:{?}##");
                        }
                    }
                }
            }
            if (f == null || f.acceptRedirectError()) {
                if (this.base.redirectErrorStream()) {
                    sb.append("##:separator:").append(this.escape(session, " 2>&1")).append("##");
                } else if (f == null || f.acceptRedirectError()) {
                    ProcessBuilder.Redirect r = this.base.redirectError();
                    if (null == r.type()) {
                        sb.append("##:separator:").append(this.escape(session, " 2>")).append("## ").append("##:pale:{?}##");
                    } else {
                        switch (r.type()) {
                            case INHERIT: {
                                break;
                            }
                            case PIPE: {
                                break;
                            }
                            case WRITE: {
                                sb.append("##:separator:").append(this.escape(session, " 2>")).append("## ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                                break;
                            }
                            case APPEND: {
                                sb.append("##:separator:").append(this.escape(session, " 2>>")).append("## ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                                break;
                            }
                            default: {
                                sb.append("##:separator:").append(this.escape(session, " 2>")).append("## ").append("##:pale:{?}##");
                            }
                        }
                    }
                }
            }
            if (f == null || f.acceptRedirectInput()) {
                ProcessBuilder.Redirect r = this.base.redirectInput();
                if (null == r.type()) {
                    sb.append("##:separator:").append(this.escape(session, " <")).append("## ").append("##:pale:{?}##");
                } else {
                    switch (r.type()) {
                        case INHERIT: {
                            break;
                        }
                        case PIPE: {
                            break;
                        }
                        case READ: {
                            sb.append("##:separator:").append(this.escape(session, " <")).append("## ").append(CoreStringUtils.enforceDoubleQuote(r.file().getPath()));
                            break;
                        }
                        default: {
                            sb.append("##:separator:").append(this.escape(session, " <")).append("## ").append("##:pale:{?}##");
                        }
                    }
                }
            }
        } else if (this.base.redirectErrorStream()) {
            if (this.out != null) {
                if (f == null || f.acceptRedirectOutput()) {
                    sb.append("##:separator:").append(this.escape(session, " > ")).append("## ").append("##:pale:{stream}##");
                }
                if (f == null || f.acceptRedirectError()) {
                    sb.append("##:separator:").append(this.escape(session, " 2>&1")).append("##");
                }
            }
            if (this.in != null && (f == null || f.acceptRedirectInput())) {
                sb.append("##:separator:").append(this.escape(session, " <")).append("## ").append("##:pale:{stream}##");
            }
        } else {
            if (this.out != null && (f == null || f.acceptRedirectOutput())) {
                sb.append("##:separator:").append(this.escape(session, " >")).append("## ").append("##:pale:{stream}##");
            }
            if (this.err != null && (f == null || f.acceptRedirectError())) {
                sb.append("##:separator:").append(this.escape(session, " 2>")).append("## ").append("##:pale:{stream}##");
            }
            if (this.in != null && (f == null || f.acceptRedirectInput())) {
                sb.append("##:separator:").append(this.escape(session, " <")).append("## ").append("##:pale:{stream}##");
            }
        }
        return sb.toString();
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public ProcessBuilder2 setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public ProcessBuilder2 setFailFast() {
        return this.setFailFast(true);
    }

    private PipeThread pipe(String name, NonBlockingInputStream in, OutputStream out) {
        PipeThread p = new PipeThread(name, in, out, this.session);
        p.start();
        return p;
    }

    public String toString() {
        return "ProcessBuilder2{command=" + this.command + ", env=" + this.env + ", directory=" + this.directory + ", base=" + this.base + ", in=" + this.in + ", out=" + this.out + ", err=" + this.err + ", result=" + this.result + ", baseIO=" + this.baseIO + ", failFast=" + this.failFast + ", proc=" + this.proc + ", sleepMillis=" + this.sleepMillis + ", session=" + this.session + '}';
    }

    private static class SPrintStream
    extends PrintStream {
        private ByteArrayOutputStream out;

        public SPrintStream() {
            this(new ByteArrayOutputStream());
        }

        public SPrintStream(ByteArrayOutputStream out1) {
            super(out1);
            this.out = out1;
        }

        public String getStringBuffer() {
            this.flush();
            return new String(this.out.toByteArray());
        }
    }

    public static interface CommandStringFormat {
        default public boolean acceptArgument(int argIndex, String arg) {
            return true;
        }

        default public String replaceArgument(int argIndex, String arg) {
            return null;
        }

        default public boolean acceptEnvName(String envName, String envValue) {
            return true;
        }

        default public boolean acceptRedirectInput() {
            return true;
        }

        default public boolean acceptRedirectOutput() {
            return true;
        }

        default public boolean acceptRedirectError() {
            return true;
        }

        default public String replaceEnvName(String envName, String envValue) {
            return null;
        }

        default public String replaceEnvValue(String envName, String envValue) {
            return null;
        }
    }
}

