/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.bundles.io.NonBlockingInputStream;
import net.thevpc.nuts.runtime.bundles.io.StopMonitor;

public class PipeThread
extends Thread
implements StopMonitor {
    private final NonBlockingInputStream in;
    private final OutputStream out;
    private final Object lock = new Object();
    private long pipedBytesCount = 0L;
    private boolean requestStop = false;
    private boolean stopped = false;
    private NutsSession session;

    public PipeThread(String name, NonBlockingInputStream in, OutputStream out, NutsSession session) {
        super(name);
        this.in = in;
        this.out = out;
        this.session = session;
    }

    @Override
    public boolean shouldStop() {
        return this.requestStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.requestStop = true;
        if (!this.stopped) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.session.getWorkspace().log().of(PipeThread.class).with().error((Throwable)e).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("lock-wait interrupted", new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] bytes = new byte[10240];
            while (!this.shouldStop() && this.in.hasMoreBytes()) {
                int count = this.in.readNonBlocking(bytes, 500L);
                if (count <= 0) continue;
                this.pipedBytesCount += (long)count;
                this.out.write(bytes, 0, count);
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.session.getWorkspace().log().of(PipeThread.class).with().error((Throwable)e).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("pipe-thread exits with error: " + e.toString(), new Object[0]);
        }
        this.stopped = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public NonBlockingInputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }
}

