/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.runtime.bundles.io.InterruptException;
import net.thevpc.nuts.runtime.bundles.io.Interruptible;
import net.thevpc.nuts.runtime.bundles.io.NonBlockingInputStream;

public class NonBlockingInputStreamAdapter
extends FilterInputStream
implements NonBlockingInputStream,
Interruptible {
    private boolean hasMoreBytes = true;
    private boolean closed = false;
    private boolean interrupted = false;
    private String name;

    public NonBlockingInputStreamAdapter(String name, InputStream in) {
        super(in);
        this.name = name;
    }

    @Override
    public void interrupt() throws InterruptException {
        this.interrupted = true;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        if (this.closed) {
            return -1;
        }
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = super.read();
        if (read < 0) {
            this.hasMoreBytes = false;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = super.read(b);
        if (read < 0) {
            this.hasMoreBytes = false;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        block5: {
            if (this.interrupted) {
                throw new IOException(new InterruptException("Interrupted"));
            }
            if (this.available() == 0 && !this.hasMoreBytes()) {
                return -1;
            }
            read = -1;
            try {
                read = super.read(b, off, len);
            }
            catch (IOException ex) {
                if (ex.getMessage().equals("Stream closed")) break block5;
                throw ex;
            }
        }
        if (read < 0) {
            this.hasMoreBytes = false;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return 0L;
        }
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        if (this.closed) {
            return -1;
        }
        int available = -1;
        try {
            available = super.available();
        }
        catch (IOException ex) {
            return -1;
        }
        if (available < 0) {
            if (!this.closed) {
                this.close();
            }
            return -1;
        }
        if (available == 0 && !this.hasMoreBytes) {
            return -1;
        }
        if (this.closed) {
            return -1;
        }
        return available;
    }

    @Override
    public int readNonBlocking(byte[] b, long timeout) throws IOException {
        return this.readNonBlocking(b, 0, b.length, timeout);
    }

    @Override
    public int readNonBlocking(byte[] b, int off, int len, long timeout) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        long now = System.currentTimeMillis();
        long then = now + timeout;
        long tic = 100L;
        while (true) {
            if (this.interrupted) {
                throw new IOException(new InterruptException("Interrupted"));
            }
            if (this.closed) break;
            int available = this.available();
            if (available < 0) {
                this.hasMoreBytes = false;
                break;
            }
            if (available > 0) {
                return this.read(b, off, len);
            }
            if (!this.hasMoreBytes() || (now = System.currentTimeMillis()) > then) break;
            try {
                Thread.sleep(tic);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return 0;
    }

    @Override
    public int readNonBlocking(byte[] b) throws IOException {
        return this.readNonBlocking(b, 0, b.length);
    }

    @Override
    public int readNonBlocking(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        int available = this.available();
        if (available < 0) {
            this.hasMoreBytes = false;
        } else {
            if (available > 0) {
                return this.read(b, off, len);
            }
            if (!this.hasMoreBytes()) {
                // empty if block
            }
        }
        return 0;
    }

    @Override
    public void noMoreBytes() {
        this.hasMoreBytes = false;
    }

    @Override
    public boolean hasMoreBytes() {
        return this.hasMoreBytes;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.hasMoreBytes = false;
        this.closed = true;
    }
}

