/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadata;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAware;
import net.thevpc.nuts.runtime.bundles.io.InterruptException;
import net.thevpc.nuts.runtime.bundles.io.Interruptible;

public class InputStreamTee
extends InputStream
implements InputStreamMetadataAware,
Interruptible {
    private InputStream in;
    private OutputStream out;
    private Runnable onClose;
    private boolean interrupted;

    public InputStreamTee(InputStream in, OutputStream out, Runnable onClose) {
        this.in = in;
        this.out = out;
        this.onClose = onClose;
    }

    @Override
    public void interrupt() throws InterruptException {
        this.interrupted = true;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        int x = this.in.read();
        if (x >= 0) {
            this.out.write(x);
        }
        return x;
    }

    @Override
    public void close() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        this.in.close();
        this.out.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        int p = this.in.read(b, off, len);
        if (p > 0) {
            this.out.write(b, off, p);
        }
        return p;
    }

    @Override
    public InputStreamMetadata getMetaData() {
        if (this.in instanceof InputStreamMetadataAware) {
            return ((InputStreamMetadataAware)((Object)this.in)).getMetaData();
        }
        return null;
    }
}

