/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class CoreSecurityUtils {
    public static final String ENV_KEY_PASSPHRASE = "passphrase";
    public static final String DEFAULT_PASSPHRASE = CoreIOUtils.bytesToHex("It's completely nuts!!".getBytes());

    public static char[] defaultDecryptChars(char[] data, String passphrase) {
        return CoreSecurityUtils.decryptString(new String(data), passphrase).toCharArray();
    }

    public static char[] defaultEncryptChars(char[] data, String passphrase) {
        return CoreSecurityUtils.encryptString(new String(data), passphrase).toCharArray();
    }

    public static char[] defaultHashChars(char[] data, String passphrase) {
        return CoreSecurityUtils.defaultEncryptChars(CoreIOUtils.evalSHA1(data), passphrase);
    }

    private static String encryptString(String strToEncrypt, String secret) {
        try {
            byte[] bytes = strToEncrypt.getBytes(StandardCharsets.UTF_8);
            int v = bytes.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(v >>> 24 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 0 & 0xFF);
            out.write(bytes);
            int s = v + 4;
            while (s % 16 != 0) {
                out.write(0);
                ++s;
            }
            bytes = out.toByteArray();
            KeyInfo k = CoreSecurityUtils.createKeyInfo(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, k.secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(bytes));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String decryptString(String strToDecrypt, String secret) {
        try {
            KeyInfo k = CoreSecurityUtils.createKeyInfo(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, k.secretKey);
            byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(strToDecrypt));
            int ch1 = bytes[0] & 0xFF;
            int ch2 = bytes[1] & 0xFF;
            int ch3 = bytes[2] & 0xFF;
            int ch4 = bytes[3] & 0xFF;
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                throw new EOFException();
            }
            int v = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
            bytes = Arrays.copyOfRange(bytes, 4, 4 + v);
            return new String(bytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static KeyInfo createKeyInfo(String password) {
        if (password == null || password.length() == 0) {
            password = "password";
        }
        MessageDigest sha = null;
        KeyInfo k = new KeyInfo();
        try {
            k.key = password.getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            k.key = sha.digest(k.key);
            k.secretKey = new SecretKeySpec(k.key, "AES");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        return k;
    }

    private static class KeyInfo {
        SecretKeySpec secretKey;
        byte[] key;

        private KeyInfo() {
        }
    }
}

