/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;

public abstract class AbstractNutsOutput
implements NutsOutput {
    private final Object value;
    private final boolean path;
    private final boolean url;
    private final String name;
    private final String typeName;
    private final NutsSession session;

    public AbstractNutsOutput(Object value, boolean path, boolean url, String name, String typeName, NutsSession session) {
        this.value = value;
        this.path = path;
        this.url = url;
        this.typeName = typeName;
        if (name == null) {
            name = String.valueOf(value);
        }
        this.name = name;
        this.session = session;
    }

    protected NutsIOException createOpenError(Exception ex) {
        String n = this.getTypeName();
        if (n == null) {
            n = this.getName();
        }
        return new NutsIOException(this.session, NutsMessage.cstyle((String)"%s not found : %s", (Object[])new Object[]{n, this.toString()}), (Throwable)ex);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public abstract OutputStream open();

    public Object getSource() {
        return this.value;
    }

    public boolean isPath() {
        return this.path;
    }

    public Path getFilePath() {
        throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported operation '%s'", (Object[])new Object[]{"getFilePath"}));
    }

    public boolean isURL() {
        return this.url;
    }

    public URL getURL() {
        throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported operation '%s'", (Object[])new Object[]{"getURL"}));
    }
}

