/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.bundles.string.GlobUtils;
import net.thevpc.nuts.runtime.core.model.DefaultNutsVersion;

public class JavascriptHelper {
    public List<Pattern> blacklistClassNamePatterns = new ArrayList<Pattern>();
    private ScriptEngine engine;
    private final NutsSession session;
    private final Set<String> blacklistClassNames = new HashSet<String>(Arrays.asList("java.io.File", "java.lang.Process", "java.lang.System", "java.lang.Thread"));

    public JavascriptHelper(String code, String initExprs, Set<String> blacklist, Object util, NutsSession session) {
        this.session = session;
        if (blacklist == null) {
            this.blacklistClassNames.addAll(Arrays.asList("java.io.File", "java.lang.Process", "java.lang.System", "java.lang.Thread"));
        } else {
            for (String s : blacklist) {
                if (s.contains("*")) {
                    this.blacklistClassNamePatterns.add(GlobUtils.ofExact(s));
                    continue;
                }
                this.blacklistClassNames.add(s);
            }
        }
        if (code == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"illegal js filter : empty content", (Object[])new Object[0]));
        }
        if (!code.contains("return")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"js filter must contain a return clause", (Object[])new Object[0]));
        }
        try {
            this.engine = this.createScriptEngine();
        }
        catch (Exception ex) {
            this.engine = this.createManagerJdk();
        }
        try {
            if (NutsUtilStrings.isBlank((CharSequence)initExprs)) {
                initExprs = "";
            }
            this.engine.eval("function accept(x) { " + initExprs + code + " }");
            if (util == null) {
                util = new NutScriptUtil(session);
            }
            this.engine.put("util", util);
        }
        catch (ScriptException e) {
            throw new NutsParseException(session, NutsMessage.plain((String)"javascript execution failed"), (Throwable)e);
        }
    }

    public void createEngine(String code, String initExprs) {
    }

    private ScriptEngine createScriptEngine() {
        NashornScriptEngineFactory f = new NashornScriptEngineFactory();
        return f.getScriptEngine(new ClassFilter(){

            public boolean exposeToScripts(String s) {
                if (JavascriptHelper.this.blacklistClassNames.contains(s)) {
                    return false;
                }
                for (Pattern pattern : JavascriptHelper.this.blacklistClassNamePatterns) {
                    if (!pattern.matcher(s).matches()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private ScriptEngine createManagerJdk() {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        return engineManager.getEngineByName("nashorn");
    }

    public boolean accept(Object id) {
        this.engine.put("x", id);
        try {
            return Boolean.TRUE.equals(this.engine.eval("accept(x);"));
        }
        catch (ScriptException e) {
            throw new NutsParseException(this.session, NutsMessage.plain((String)"javascript execution failed"), (Throwable)e);
        }
    }

    public static class NutScriptUtil {
        NutsSession session;

        public NutScriptUtil(NutsSession session) {
            this.session = session;
        }

        public boolean matches(Object value, String pattern) {
            if (value == null) {
                value = "";
            }
            if (value instanceof String) {
                if (pattern == null) {
                    pattern = "";
                }
                return GlobUtils.ofContains(pattern).matcher(value.toString()).matches();
            }
            if (NutsUtilStrings.isBlank((CharSequence)pattern)) {
                return NutsUtilStrings.isBlank((CharSequence)value.toString());
            }
            if (value instanceof NutsId) {
                NutsIdFilter f = this.session.getWorkspace().id().filter().byExpression(pattern);
                return f.acceptId((NutsId)value, this.session);
            }
            if (value instanceof NutsDependency) {
                NutsDependencyFilter f = this.session.getWorkspace().dependency().filter().byExpression(pattern);
                NutsId from = null;
                return f == null || f.acceptDependency(from, (NutsDependency)value, this.session);
            }
            if (value instanceof NutsVersion) {
                NutsVersionFilter f = this.session.getWorkspace().version().filter().byExpression(pattern);
                return f == null || f.acceptVersion((NutsVersion)value, this.session);
            }
            return true;
        }

        public int compareVersions(String v1, String v2) {
            return DefaultNutsVersion.compareVersions(v1, v2);
        }
    }
}

