/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.collections;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;

public class BTreeSet<T extends Comparable<T>> {
    private int minKeySize = 1;
    private int minChildrenSize = this.minKeySize + 1;
    private int maxKeySize = 2 * this.minKeySize;
    private int maxChildrenSize = this.maxKeySize + 1;
    private Node<T> root = null;
    private int size = 0;

    public BTreeSet() {
    }

    public BTreeSet(int order) {
        this.minKeySize = order;
        this.minChildrenSize = this.minKeySize + 1;
        this.maxKeySize = 2 * this.minKeySize;
        this.maxChildrenSize = this.maxKeySize + 1;
    }

    public boolean add(T value) {
        if (this.root == null) {
            this.root = new Node(null, this.maxKeySize, this.maxChildrenSize);
            ((Node)this.root).addKey(value);
        } else {
            Node node = this.root;
            block0: while (node != null) {
                if (node.numberOfChildren() == 0) {
                    node.addKey(value);
                    if (node.numberOfKeys() <= this.maxKeySize) break;
                    this.split(node);
                    break;
                }
                Comparable lesser = node.getKey(0);
                if (value.compareTo((Comparable)lesser) <= 0) {
                    node = node.getChild(0);
                    continue;
                }
                int numberOfKeys = node.numberOfKeys();
                int last = numberOfKeys - 1;
                Comparable greater = node.getKey(last);
                if (value.compareTo((Comparable)greater) > 0) {
                    node = node.getChild(numberOfKeys);
                    continue;
                }
                for (int i = 1; i < node.numberOfKeys(); ++i) {
                    Comparable prev = node.getKey(i - 1);
                    Comparable next = node.getKey(i);
                    if (value.compareTo((Comparable)prev) <= 0 || value.compareTo((Comparable)next) > 0) continue;
                    node = node.getChild(i);
                    continue block0;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void split(Node<T> nodeToSplit) {
        Node<T> node = nodeToSplit;
        int numberOfKeys = ((Node)node).numberOfKeys();
        int medianIndex = numberOfKeys / 2;
        Comparable medianValue = ((Node)node).getKey(medianIndex);
        Node left = new Node(null, this.maxKeySize, this.maxChildrenSize);
        for (int i = 0; i < medianIndex; ++i) {
            left.addKey(((Node)node).getKey(i));
        }
        if (((Node)node).numberOfChildren() > 0) {
            for (int j = 0; j <= medianIndex; ++j) {
                Node c = ((Node)node).getChild(j);
                left.addChild(c);
            }
        }
        Node right = new Node(null, this.maxKeySize, this.maxChildrenSize);
        for (int i = medianIndex + 1; i < numberOfKeys; ++i) {
            right.addKey(((Node)node).getKey(i));
        }
        if (((Node)node).numberOfChildren() > 0) {
            for (int j = medianIndex + 1; j < ((Node)node).numberOfChildren(); ++j) {
                Node c = ((Node)node).getChild(j);
                right.addChild(c);
            }
        }
        if (node.parent == null) {
            Node newRoot = new Node(null, this.maxKeySize, this.maxChildrenSize);
            newRoot.addKey(medianValue);
            node.parent = newRoot;
            this.root = newRoot;
            node = this.root;
            ((Node)node).addChild(left);
            ((Node)node).addChild(right);
        } else {
            Node parent = node.parent;
            parent.addKey(medianValue);
            parent.removeChild((Node)node);
            parent.addChild(left);
            parent.addChild(right);
            if (parent.numberOfKeys() > this.maxKeySize) {
                this.split(parent);
            }
        }
    }

    public T remove(T value) {
        T removed = null;
        Node<T> node = this.getNode(value);
        removed = this.remove(value, node);
        return removed;
    }

    private T remove(T value, Node<T> node) {
        if (node == null) {
            return null;
        }
        Comparable removed = null;
        int index = ((Node)node).indexOf(value);
        removed = ((Node)node).removeKey(value);
        if (((Node)node).numberOfChildren() == 0) {
            if (node.parent != null && ((Node)node).numberOfKeys() < this.minKeySize) {
                this.combined(node);
            } else if (node.parent == null && ((Node)node).numberOfKeys() == 0) {
                this.root = null;
            }
        } else {
            Node lesser = ((Node)node).getChild(index);
            Node<T> greatest = this.getGreatestNode(lesser);
            T replaceValue = this.removeGreatestValue(greatest);
            ((Node)node).addKey(replaceValue);
            if (greatest.parent != null && ((Node)greatest).numberOfKeys() < this.minKeySize) {
                this.combined(greatest);
            }
            if (((Node)greatest).numberOfChildren() > this.maxChildrenSize) {
                this.split(greatest);
            }
        }
        --this.size;
        return (T)removed;
    }

    private T removeGreatestValue(Node<T> node) {
        Comparable value = null;
        if (((Node)node).numberOfKeys() > 0) {
            value = ((Node)node).removeKey(((Node)node).numberOfKeys() - 1);
        }
        return (T)value;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    public boolean contains(T value) {
        Node<T> node = this.getNode(value);
        return node != null;
    }

    private Node<T> getNode(T value) {
        Node node = this.root;
        block0: while (node != null) {
            Comparable lesser = node.getKey(0);
            if (value.compareTo((Comparable)lesser) < 0) {
                if (node.numberOfChildren() > 0) {
                    node = node.getChild(0);
                    continue;
                }
                node = null;
                continue;
            }
            int numberOfKeys = node.numberOfKeys();
            int last = numberOfKeys - 1;
            Comparable greater = node.getKey(last);
            if (value.compareTo((Comparable)greater) > 0) {
                if (node.numberOfChildren() > numberOfKeys) {
                    node = node.getChild(numberOfKeys);
                    continue;
                }
                node = null;
                continue;
            }
            for (int i = 0; i < numberOfKeys; ++i) {
                Comparable currentValue = node.getKey(i);
                if (currentValue.compareTo(value) == 0) {
                    return node;
                }
                int next = i + 1;
                if (next > last) continue;
                Comparable nextValue = node.getKey(next);
                if (currentValue.compareTo(value) >= 0 || nextValue.compareTo(value) <= 0) continue;
                if (next < node.numberOfChildren()) {
                    node = node.getChild(next);
                    continue block0;
                }
                return null;
            }
        }
        return null;
    }

    public T getCurrentValue(T value) {
        Node node = this.root;
        block0: while (node != null) {
            Comparable lesser = node.getKey(0);
            if (value.compareTo((Comparable)lesser) < 0) {
                if (node.numberOfChildren() > 0) {
                    node = node.getChild(0);
                    continue;
                }
                node = null;
                continue;
            }
            int numberOfKeys = node.numberOfKeys();
            int last = numberOfKeys - 1;
            Comparable greater = node.getKey(last);
            if (value.compareTo((Comparable)greater) > 0) {
                if (node.numberOfChildren() > numberOfKeys) {
                    node = node.getChild(numberOfKeys);
                    continue;
                }
                node = null;
                continue;
            }
            for (int i = 0; i < numberOfKeys; ++i) {
                Comparable currentValue = node.getKey(i);
                if (currentValue.compareTo(value) == 0) {
                    return (T)currentValue;
                }
                int next = i + 1;
                if (next > last) continue;
                Comparable nextValue = node.getKey(next);
                if (currentValue.compareTo(value) >= 0 || nextValue.compareTo(value) <= 0) continue;
                if (next < node.numberOfChildren()) {
                    node = node.getChild(next);
                    continue block0;
                }
                return null;
            }
        }
        return null;
    }

    private Node<T> getGreatestNode(Node<T> nodeToGet) {
        Node node = nodeToGet;
        while (node.numberOfChildren() > 0) {
            node = node.getChild(node.numberOfChildren() - 1);
        }
        return node;
    }

    private boolean combined(Node<T> node) {
        Node parent = node.parent;
        int index = parent.indexOf((Node)node);
        int indexOfLeftNeighbor = index - 1;
        int indexOfRightNeighbor = index + 1;
        Node rightNeighbor = null;
        int rightNeighborSize = -this.minChildrenSize;
        if (indexOfRightNeighbor < parent.numberOfChildren()) {
            rightNeighbor = parent.getChild(indexOfRightNeighbor);
            rightNeighborSize = rightNeighbor.numberOfKeys();
        }
        if (rightNeighbor != null && rightNeighborSize > this.minKeySize) {
            Comparable removeValue = rightNeighbor.getKey(0);
            int prev = this.getIndexOfPreviousValue(parent, removeValue);
            Comparable parentValue = parent.removeKey(prev);
            Comparable neighborValue = rightNeighbor.removeKey(0);
            ((Node)node).addKey(parentValue);
            parent.addKey(neighborValue);
            if (rightNeighbor.numberOfChildren() > 0) {
                ((Node)node).addChild((Node)rightNeighbor.removeChild(0));
            }
        } else {
            Node leftNeighbor = null;
            int leftNeighborSize = -this.minChildrenSize;
            if (indexOfLeftNeighbor >= 0) {
                leftNeighbor = parent.getChild(indexOfLeftNeighbor);
                leftNeighborSize = leftNeighbor.numberOfKeys();
            }
            if (leftNeighbor != null && leftNeighborSize > this.minKeySize) {
                Comparable removeValue = leftNeighbor.getKey(leftNeighbor.numberOfKeys() - 1);
                int prev = this.getIndexOfNextValue(parent, removeValue);
                Comparable parentValue = parent.removeKey(prev);
                Comparable neighborValue = leftNeighbor.removeKey(leftNeighbor.numberOfKeys() - 1);
                ((Node)node).addKey(parentValue);
                parent.addKey(neighborValue);
                if (leftNeighbor.numberOfChildren() > 0) {
                    ((Node)node).addChild((Node)leftNeighbor.removeChild(leftNeighbor.numberOfChildren() - 1));
                }
            } else if (rightNeighbor != null && parent.numberOfKeys() > 0) {
                int i;
                Comparable removeValue = rightNeighbor.getKey(0);
                int prev = this.getIndexOfPreviousValue(parent, removeValue);
                Comparable parentValue = parent.removeKey(prev);
                parent.removeChild(rightNeighbor);
                ((Node)node).addKey(parentValue);
                for (i = 0; i < rightNeighbor.keysSize; ++i) {
                    Comparable v = rightNeighbor.getKey(i);
                    ((Node)node).addKey(v);
                }
                for (i = 0; i < rightNeighbor.childrenSize; ++i) {
                    Node c = rightNeighbor.getChild(i);
                    ((Node)node).addChild(c);
                }
                if (parent.parent != null && parent.numberOfKeys() < this.minKeySize) {
                    this.combined(parent);
                } else if (parent.numberOfKeys() == 0) {
                    node.parent = null;
                    this.root = node;
                }
            } else if (leftNeighbor != null && parent.numberOfKeys() > 0) {
                int i;
                Comparable removeValue = leftNeighbor.getKey(leftNeighbor.numberOfKeys() - 1);
                int prev = this.getIndexOfNextValue(parent, removeValue);
                Comparable parentValue = parent.removeKey(prev);
                parent.removeChild(leftNeighbor);
                ((Node)node).addKey(parentValue);
                for (i = 0; i < leftNeighbor.keysSize; ++i) {
                    Comparable v = leftNeighbor.getKey(i);
                    ((Node)node).addKey(v);
                }
                for (i = 0; i < leftNeighbor.childrenSize; ++i) {
                    Node c = leftNeighbor.getChild(i);
                    ((Node)node).addChild(c);
                }
                if (parent.parent != null && parent.numberOfKeys() < this.minKeySize) {
                    this.combined(parent);
                } else if (parent.numberOfKeys() == 0) {
                    node.parent = null;
                    this.root = node;
                }
            }
        }
        return true;
    }

    private int getIndexOfPreviousValue(Node<T> node, T value) {
        for (int i = 1; i < ((Node)node).numberOfKeys(); ++i) {
            Comparable t = ((Node)node).getKey(i);
            if (t.compareTo(value) < 0) continue;
            return i - 1;
        }
        return ((Node)node).numberOfKeys() - 1;
    }

    private int getIndexOfNextValue(Node<T> node, T value) {
        for (int i = 0; i < ((Node)node).numberOfKeys(); ++i) {
            Comparable t = ((Node)node).getKey(i);
            if (t.compareTo(value) < 0) continue;
            return i;
        }
        return ((Node)node).numberOfKeys() - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean validate() {
        if (this.root == null) {
            return true;
        }
        return this.validateNode(this.root);
    }

    private boolean validateNode(Node<T> node) {
        int i;
        Node first;
        int keySize = ((Node)node).numberOfKeys();
        if (keySize > 1) {
            for (int i2 = 1; i2 < keySize; ++i2) {
                Comparable n;
                Comparable p = ((Node)node).getKey(i2 - 1);
                if (p.compareTo(n = ((Node)node).getKey(i2)) <= 0) continue;
                return false;
            }
        }
        int childrenSize = ((Node)node).numberOfChildren();
        if (node.parent == null) {
            if (keySize > this.maxKeySize) {
                return false;
            }
            if (childrenSize == 0) {
                return true;
            }
            if (childrenSize < 2) {
                return false;
            }
            if (childrenSize > this.maxChildrenSize) {
                return false;
            }
        } else {
            if (keySize < this.minKeySize) {
                return false;
            }
            if (keySize > this.maxKeySize) {
                return false;
            }
            if (childrenSize == 0) {
                return true;
            }
            if (keySize != childrenSize - 1) {
                return false;
            }
            if (childrenSize < this.minChildrenSize) {
                return false;
            }
            if (childrenSize > this.maxChildrenSize) {
                return false;
            }
        }
        if ((first = ((Node)node).getChild(0)).getKey(first.numberOfKeys() - 1).compareTo(((Node)node).getKey(0)) > 0) {
            return false;
        }
        Node last = ((Node)node).getChild(((Node)node).numberOfChildren() - 1);
        if (last.getKey(0).compareTo(((Node)node).getKey(((Node)node).numberOfKeys() - 1)) < 0) {
            return false;
        }
        for (i = 1; i < ((Node)node).numberOfKeys(); ++i) {
            Comparable p = ((Node)node).getKey(i - 1);
            Comparable n = ((Node)node).getKey(i);
            Node c = ((Node)node).getChild(i);
            if (p.compareTo(c.getKey(0)) > 0) {
                return false;
            }
            if (n.compareTo(c.getKey(c.numberOfKeys() - 1)) >= 0) continue;
            return false;
        }
        for (i = 0; i < ((Node)node).childrenSize; ++i) {
            Node c = ((Node)node).getChild(i);
            boolean valid = this.validateNode(c);
            if (valid) continue;
            return false;
        }
        return true;
    }

    public Collection<T> toCollection() {
        return new JavaCompatibleBTree(this);
    }

    public String toString() {
        return TreePrinter.getString(this);
    }

    public static class JavaCompatibleBTree<T extends Comparable<T>>
    extends AbstractCollection<T> {
        private BTreeSet<T> tree = null;

        public JavaCompatibleBTree(BTreeSet<T> tree) {
            this.tree = tree;
        }

        @Override
        public boolean add(T value) {
            return this.tree.add(value);
        }

        @Override
        public boolean remove(Object value) {
            return this.tree.remove((Comparable)value) != null;
        }

        @Override
        public boolean contains(Object value) {
            return this.tree.contains((Comparable)value);
        }

        @Override
        public int size() {
            return this.tree.size();
        }

        @Override
        public Iterator<T> iterator() {
            return new BTreeIterator<T>(this.tree);
        }

        private static class BTreeIterator<C extends Comparable<C>>
        implements Iterator<C> {
            private BTreeSet<C> tree = null;
            private Node<C> lastNode = null;
            private C lastValue = null;
            private int index = 0;
            private Deque<Node<C>> toVisit = new ArrayDeque<Node<C>>();

            protected BTreeIterator(BTreeSet<C> tree) {
                this.tree = tree;
                if (((BTreeSet)tree).root != null && ((BTreeSet)tree).root.keysSize > 0) {
                    this.toVisit.add(((BTreeSet)tree).root);
                }
            }

            @Override
            public boolean hasNext() {
                return this.lastNode != null && this.index < ((Node)this.lastNode).keysSize || this.toVisit.size() > 0;
            }

            @Override
            public C next() {
                if (this.lastNode != null && this.index < ((Node)this.lastNode).keysSize) {
                    this.lastValue = ((Node)this.lastNode).getKey(this.index++);
                    return this.lastValue;
                }
                if (this.toVisit.size() > 0) {
                    Node<C> n = this.toVisit.pop();
                    for (int i = 0; i < ((Node)n).childrenSize; ++i) {
                        this.toVisit.add(((Node)n).getChild(i));
                    }
                    this.index = 0;
                    this.lastNode = n;
                    this.lastValue = ((Node)this.lastNode).getKey(this.index++);
                    return this.lastValue;
                }
                return null;
            }

            @Override
            public void remove() {
                if (this.lastNode != null && this.lastValue != null) {
                    ((BTreeSet)this.tree).remove(this.lastValue, this.lastNode);
                    this.lastNode = null;
                    this.lastValue = null;
                    this.index = 0;
                    this.toVisit.clear();
                    if (((BTreeSet)this.tree).root != null && ((BTreeSet)this.tree).root.keysSize > 0) {
                        this.toVisit.add(((BTreeSet)this.tree).root);
                    }
                }
            }
        }
    }

    private static class TreePrinter {
        private TreePrinter() {
        }

        public static <T extends Comparable<T>> String getString(BTreeSet<T> tree) {
            if (((BTreeSet)tree).root == null) {
                return "Tree has no nodes.";
            }
            return TreePrinter.getString(((BTreeSet)tree).root, "", true);
        }

        private static <T extends Comparable<T>> String getString(Node<T> node, String prefix, boolean isTail) {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
            for (i = 0; i < ((Node)node).numberOfKeys(); ++i) {
                Comparable value = ((Node)node).getKey(i);
                builder.append(value);
                if (i >= ((Node)node).numberOfKeys() - 1) continue;
                builder.append(", ");
            }
            builder.append("\n");
            if (((Node)node).children != null) {
                for (i = 0; i < ((Node)node).numberOfChildren() - 1; ++i) {
                    Node obj = ((Node)node).getChild(i);
                    builder.append(TreePrinter.getString(obj, prefix + (isTail ? "    " : "\u2502   "), false));
                }
                if (((Node)node).numberOfChildren() >= 1) {
                    Node obj = ((Node)node).getChild(((Node)node).numberOfChildren() - 1);
                    builder.append(TreePrinter.getString(obj, prefix + (isTail ? "    " : "\u2502   "), true));
                }
            }
            return builder.toString();
        }
    }

    private static class Node<T extends Comparable<T>> {
        private T[] keys = null;
        private int keysSize = 0;
        private Node<T>[] children = null;
        private int childrenSize = 0;
        private Comparator<Node<T>> comparator = new Comparator<Node<T>>(){

            @Override
            public int compare(Node<T> arg0, Node<T> arg1) {
                return arg0.getKey(0).compareTo(arg1.getKey(0));
            }
        };
        protected Node<T> parent = null;

        private Node(Node<T> parent, int maxKeySize, int maxChildrenSize) {
            this.parent = parent;
            this.keys = new Comparable[maxKeySize + 1];
            this.keysSize = 0;
            this.children = new Node[maxChildrenSize + 1];
            this.childrenSize = 0;
        }

        private T getKey(int index) {
            return this.keys[index];
        }

        private int indexOf(T value) {
            for (int i = 0; i < this.keysSize; ++i) {
                if (!this.keys[i].equals(value)) continue;
                return i;
            }
            return -1;
        }

        private void addKey(T value) {
            this.keys[this.keysSize++] = value;
            Arrays.sort(this.keys, 0, this.keysSize);
        }

        private T removeKey(T value) {
            T removed = null;
            boolean found = false;
            if (this.keysSize == 0) {
                return null;
            }
            for (int i = 0; i < this.keysSize; ++i) {
                if (this.keys[i].equals(value)) {
                    found = true;
                    removed = this.keys[i];
                    continue;
                }
                if (!found) continue;
                this.keys[i - 1] = this.keys[i];
            }
            if (found) {
                --this.keysSize;
                this.keys[this.keysSize] = null;
            }
            return removed;
        }

        private T removeKey(int index) {
            if (index >= this.keysSize) {
                return null;
            }
            T value = this.keys[index];
            for (int i = index + 1; i < this.keysSize; ++i) {
                this.keys[i - 1] = this.keys[i];
            }
            --this.keysSize;
            this.keys[this.keysSize] = null;
            return value;
        }

        private int numberOfKeys() {
            return this.keysSize;
        }

        private Node<T> getChild(int index) {
            if (index >= this.childrenSize) {
                return null;
            }
            return this.children[index];
        }

        private int indexOf(Node<T> child) {
            for (int i = 0; i < this.childrenSize; ++i) {
                if (!this.children[i].equals(child)) continue;
                return i;
            }
            return -1;
        }

        private boolean addChild(Node<T> child) {
            child.parent = this;
            this.children[this.childrenSize++] = child;
            Arrays.sort(this.children, 0, this.childrenSize, this.comparator);
            return true;
        }

        private boolean removeChild(Node<T> child) {
            boolean found = false;
            if (this.childrenSize == 0) {
                return found;
            }
            for (int i = 0; i < this.childrenSize; ++i) {
                if (this.children[i].equals(child)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                this.children[i - 1] = this.children[i];
            }
            if (found) {
                --this.childrenSize;
                this.children[this.childrenSize] = null;
            }
            return found;
        }

        private Node<T> removeChild(int index) {
            if (index >= this.childrenSize) {
                return null;
            }
            Node<T> value = this.children[index];
            this.children[index] = null;
            for (int i = index + 1; i < this.childrenSize; ++i) {
                this.children[i - 1] = this.children[i];
            }
            --this.childrenSize;
            this.children[this.childrenSize] = null;
            return value;
        }

        private int numberOfChildren() {
            return this.childrenSize;
        }

        public String toString() {
            T value;
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("keys=[");
            for (i = 0; i < this.numberOfKeys(); ++i) {
                value = this.getKey(i);
                builder.append(value);
                if (i >= this.numberOfKeys() - 1) continue;
                builder.append(", ");
            }
            builder.append("]\n");
            if (this.parent != null) {
                builder.append("parent=[");
                for (i = 0; i < super.numberOfKeys(); ++i) {
                    value = super.getKey(i);
                    builder.append(value);
                    if (i >= super.numberOfKeys() - 1) continue;
                    builder.append(", ");
                }
                builder.append("]\n");
            }
            if (this.children != null) {
                builder.append("keySize=").append(this.numberOfKeys()).append(" children=").append(this.numberOfChildren()).append("\n");
            }
            return builder.toString();
        }
    }
}

