/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.tomcatclassloader;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsSession;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NutsTomcatClassLoader
extends WebappClassLoader {
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String SERVICES_PREFIX = "/META-INF/services/";
    private static final Log log = LogFactory.getLog(WebappClassLoaderBase.class);
    protected NutsSession nutsWorkspace;
    protected ClassLoader nutsClassLoader;
    protected boolean nutsClassLoaderUnderConstruction;
    protected String nutsPath;
    protected String workspaceLocation;
    protected String workspaceBootRuntime;
    protected String workspaceExcludedRepositories;
    protected String workspaceExcludedExtensions;
    protected String workspaceArchetype;

    public NutsTomcatClassLoader() {
    }

    public NutsTomcatClassLoader(ClassLoader parent) {
        super(parent);
    }

    public URL[] getURLs() {
        ArrayList<URL> all = new ArrayList<URL>(Arrays.asList(super.getURLs()));
        ClassLoader classLoader = this.resolveNutsClassLoader();
        if (classLoader instanceof URLClassLoader) {
            all.addAll(Arrays.asList(((URLClassLoader)classLoader).getURLs()));
        }
        return all.toArray(new URL[0]);
    }

    public void setResources(WebResourceRoot resources) {
        URL url;
        WebResource resource;
        super.setResources(resources);
        if (resources != null && (resource = resources.getResource("/META-INF/context.xml")) != null && (url = resource.getURL()) != null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                try (InputStream is = resource.getURL().openStream();){
                    Document doc = db.parse(is);
                    NodeList loader = doc.getDocumentElement().getElementsByTagName("Loader");
                    if (loader != null) {
                        boolean ok = false;
                        for (int i = 0; i < loader.getLength(); ++i) {
                            String nodeValue;
                            Node n = loader.item(i);
                            Node loaderClass = n.getAttributes().getNamedItem("loaderClass");
                            if (loaderClass != null && "net.thevpc.nuts.tomcatclassloader.NutsTomcatClassLoader".equals(nodeValue = loaderClass.getNodeValue())) {
                                ok = true;
                            }
                            if (!ok) continue;
                            for (Field field : NutsTomcatClassLoader.class.getDeclaredFields()) {
                                Node namedItem;
                                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || (namedItem = n.getAttributes().getNamedItem(field.getName())) == null) continue;
                                field.setAccessible(true);
                                field.set((Object)this, namedItem.getNodeValue());
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ClassLoader resolveNutsClassLoader() {
        if (this.nutsClassLoader == null) {
            this.nutsClassLoaderUnderConstruction = true;
            try {
                String nutsPath = this.getNutsPath();
                String[] pathList = this.splitString(nutsPath, "; ,");
                try {
                    NutsSession session = this.resolveNutsWorkspace();
                    this.nutsClassLoader = session.search().addIds(pathList).setInlineDependencies(true).getResultClassLoader();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.nutsClassLoader = Thread.currentThread().getContextClassLoader();
                }
            }
            finally {
                this.nutsClassLoaderUnderConstruction = false;
            }
        }
        return this.nutsClassLoader;
    }

    public synchronized NutsSession resolveNutsWorkspace() {
        if (this.nutsWorkspace == null) {
            this.nutsWorkspace = Nuts.openWorkspace((NutsBootOptions)new NutsBootOptions().setRuntimeId(this.getWorkspaceBootRuntime()).setClassLoaderSupplier(() -> this.getParent()).setOpenMode(NutsOpenMode.OPEN_OR_CREATE).setWorkspace(this.getWorkspaceLocation()).setArchetype(this.getWorkspaceArchetype()).setExcludedExtensions(this.splitString(this.getWorkspaceExcludedExtensions(), " ;")));
        }
        return this.nutsWorkspace;
    }

    private String[] splitString(String nutsPath, String sep) {
        ArrayList<String> all = new ArrayList<String>();
        for (String s : (nutsPath == null ? "" : nutsPath).split("[" + sep + "]")) {
            if ((s = s.trim()).length() <= 0) continue;
            all.add(s);
        }
        return all.toArray(new String[0]);
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public void setWorkspaceLocation(String workspaceLocation) {
        this.workspaceLocation = workspaceLocation;
    }

    public String getWorkspaceBootRuntime() {
        return this.workspaceBootRuntime;
    }

    public void setWorkspaceBootRuntime(String workspaceBootRuntime) {
        this.workspaceBootRuntime = workspaceBootRuntime;
    }

    public String getWorkspaceExcludedRepositories() {
        return this.workspaceExcludedRepositories;
    }

    public void setWorkspaceExcludedRepositories(String workspaceExcludedRepositories) {
        this.workspaceExcludedRepositories = workspaceExcludedRepositories;
    }

    public String getWorkspaceExcludedExtensions() {
        return this.workspaceExcludedExtensions;
    }

    public void setWorkspaceExcludedExtensions(String workspaceExcludedExtensions) {
        this.workspaceExcludedExtensions = workspaceExcludedExtensions;
    }

    public String getWorkspaceArchetype() {
        return this.workspaceArchetype;
    }

    public void setWorkspaceArchetype(String workspaceArchetype) {
        this.workspaceArchetype = workspaceArchetype;
    }

    public String getNutsPath() {
        return this.nutsPath;
    }

    public void setNutsPath(String nutsPath) {
        this.nutsPath = nutsPath;
    }
}

