/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ntalk;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.thevpc.nuts.lib.ntalk.NTalkUtils;

public class NTalkAgent
implements Closeable {
    private static final String AGENT_VERSION = "0.8.1.0";
    private final Map<String, ServerSession> sessionsByService = new HashMap<String, ServerSession>();
    private final Map<Long, Session> sessionsById = new HashMap<Long, Session>();
    private int port;
    private long lastId = 0L;
    private long lastJobId = 0L;
    private String bindAddress;
    private int backlog;
    private ServerSocket serverSocket;
    private boolean closed;
    private ExecutorService threadPool;

    public NTalkAgent() {
        this(-1, -1, "");
    }

    public NTalkAgent(int port) {
        this(port, -1, "");
    }

    public NTalkAgent(int port, int backlog) {
        this(port, backlog, "");
    }

    public NTalkAgent(int port, int backlog, String bindAddress) {
        int n = this.port = port <= 0 ? 1401 : port;
        this.bindAddress = bindAddress == null ? null : (bindAddress.isEmpty() ? "localhost" : bindAddress);
        this.backlog = backlog <= 0 ? 50 : backlog;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public NTalkAgent setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public void runAsync() {
        try {
            if (this.threadPool == null) {
                this.threadPool = Executors.newCachedThreadPool();
            }
            this.serverSocket = new ServerSocket(this.port, this.backlog <= 0 ? 50 : this.backlog, this.bindAddress == null ? null : InetAddress.getByName(this.bindAddress));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.threadPool.submit(() -> {
            try {
                while (!this.closed) {
                    Socket s = this.serverSocket.accept();
                    this.threadPool.submit(() -> this.process(s));
                }
            }
            catch (SocketException s) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public void runSync() {
        try {
            this.threadPool = Executors.newCachedThreadPool();
            this.serverSocket = new ServerSocket(this.port);
            try {
                while (!this.closed) {
                    Socket s = this.serverSocket.accept();
                    this.threadPool.submit(() -> this.process(s));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process(Socket socket) {
        try (Session session = null;){
            DataInputStream in = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            this.log("CLIENT_SOCKET");
            int cmd = in.readInt();
            switch (cmd) {
                case 1: {
                    this.log("CONNECT:start");
                    ClientSession csession = new ClientSession();
                    csession.sessionId = this.nextId();
                    csession.socket = socket;
                    csession.inClientToAgent = in;
                    csession.outAgentToClient = out;
                    csession.outAgentToClient.writeInt(256);
                    csession.outAgentToClient.writeUTF(this.getAgentVersion());
                    csession.outAgentToClient.writeLong(csession.sessionId);
                    csession.challenge = UUID.randomUUID().toString();
                    csession.outAgentToClient.writeUTF(csession.challenge);
                    this.log("CONNECT: handshake OK " + csession.sessionId + " / " + csession.challenge);
                    session = csession;
                    this.sessionsById.put(csession.sessionId, csession);
                    this.processClient(csession);
                    return;
                }
                case 2: {
                    this.log("SERVICE:start");
                    ServerSession serverSession = new ServerSession();
                    session = serverSession;
                    serverSession.socket = socket;
                    serverSession.sessionId = this.nextId();
                    serverSession.inServerToAgent = in;
                    serverSession.outAgentToServer = out;
                    serverSession.service = serverSession.inServerToAgent.readUTF();
                    boolean serviceAlreadyRegistered = false;
                    Object object = this.sessionsByService;
                    synchronized (object) {
                        if (this.sessionsByService.containsKey(serverSession.service)) {
                            serviceAlreadyRegistered = true;
                        } else {
                            this.sessionsByService.put(serverSession.service, serverSession);
                        }
                    }
                    object = serverSession;
                    synchronized (object) {
                        if (serviceAlreadyRegistered) {
                            serverSession.outAgentToServer.writeInt(258);
                            serverSession.outAgentToServer.writeUTF(this.getAgentVersion());
                            serverSession.outAgentToServer.writeInt(-21);
                        } else {
                            serverSession.outAgentToServer.writeInt(256);
                            serverSession.outAgentToServer.writeUTF(this.getAgentVersion());
                            serverSession.outAgentToServer.writeLong(serverSession.sessionId);
                            serverSession.challenge = UUID.randomUUID().toString();
                            serverSession.outAgentToServer.writeUTF(serverSession.challenge);
                        }
                    }
                    if (serviceAlreadyRegistered) return;
                    this.log("SERVICE: handshake OK " + serverSession.sessionId + " / " + serverSession.challenge);
                    this.sessionsById.put(serverSession.sessionId, serverSession);
                    this.processServer(serverSession);
                    return;
                }
                case 3: {
                    this.log("RECONNECT:start");
                    long oldId = in.readLong();
                    String challenge = in.readUTF();
                    Session csession = this.sessionsById.get(oldId);
                    if (csession != null && csession.challenge.equals(challenge)) {
                        csession.close();
                        csession.socket = socket;
                        if (csession instanceof ClientSession) {
                            ((ClientSession)csession).inClientToAgent = in;
                            ((ClientSession)csession).outAgentToClient = out;
                        } else {
                            ((ServerSession)csession).inServerToAgent = in;
                            ((ServerSession)csession).outAgentToServer = out;
                        }
                        session = csession;
                        if (csession instanceof ClientSession) {
                            this.log("RECONNECT: handshake Client OK " + csession.sessionId + " / " + csession.challenge);
                            this.processClient((ClientSession)csession);
                            return;
                        } else {
                            this.log("RECONNECT: handshake Server OK " + csession.sessionId + " / " + csession.challenge);
                            this.processServer((ServerSession)csession);
                            return;
                        }
                    } else {
                        this.log("RECONNECT: invalid handshake");
                        return;
                    }
                }
                default: {
                    this.log("???: unexpected command");
                    return;
                }
            }
        }
    }

    private String getAgentVersion() {
        return AGENT_VERSION;
    }

    private void log(String msg) {
    }

    private synchronized long nextId() {
        return ++this.lastId;
    }

    private synchronized long nextJobId() {
        return ++this.lastJobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processClient(ClientSession clientSession) {
        try {
            boolean quit = false;
            block28: while (!quit) {
                int i = clientSession.inClientToAgent.readInt();
                switch (i) {
                    case 11: {
                        Session serverSession;
                        long jobId = this.nextJobId();
                        String serviceName = "";
                        byte[] clientRequestMessage = null;
                        int errorCode = 0;
                        String errorMessage = null;
                        try {
                            serviceName = clientSession.inClientToAgent.readUTF();
                            clientRequestMessage = NTalkUtils.readArray(clientSession.inClientToAgent);
                        }
                        catch (IOException e) {
                            errorCode = -12;
                            errorMessage = "client error: " + serviceName + ": " + e.toString();
                        }
                        if (errorCode == 0) {
                            serverSession = this.sessionsByService.get(serviceName);
                            if (serverSession != null) {
                                try {
                                    Session session = serverSession;
                                    synchronized (session) {
                                        serverSession.outAgentToServer.writeInt(13);
                                        serverSession.outAgentToServer.writeLong(jobId);
                                        serverSession.outAgentToServer.writeLong(clientSession.sessionId);
                                        NTalkUtils.writeArray(clientRequestMessage, serverSession.outAgentToServer);
                                    }
                                }
                                catch (IOException e) {
                                    errorCode = -22;
                                    errorMessage = "server error: " + serviceName + ": " + e.toString();
                                }
                            } else {
                                errorCode = -11;
                                errorMessage = "server error: " + serviceName + ": service not found " + serviceName;
                            }
                        }
                        if (errorCode == 0) continue block28;
                        try {
                            serverSession = clientSession;
                            synchronized (serverSession) {
                                clientSession.outAgentToClient.writeInt(13);
                                clientSession.outAgentToClient.writeLong(jobId);
                                clientSession.outAgentToClient.writeUTF(serviceName);
                                clientSession.outAgentToClient.writeInt(errorCode);
                                NTalkUtils.writeArray(errorMessage.getBytes(), clientSession.outAgentToClient);
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("kill client after error " + errorMessage);
                            quit = true;
                        }
                        continue block28;
                    }
                    case 255: {
                        quit = true;
                        this.sessionsById.remove(clientSession.sessionId);
                        continue block28;
                    }
                }
                System.err.println("Unexpected");
                quit = true;
                this.sessionsById.remove(clientSession.sessionId);
            }
            return;
        }
        catch (SocketException quit) {
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            NTalkAgent nTalkAgent = this;
            synchronized (nTalkAgent) {
                this.sessionsById.remove(clientSession.sessionId);
            }
            clientSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processServer(ServerSession serverSession) {
        try {
            boolean quit = false;
            block30: while (!quit) {
                int command = serverSession.inServerToAgent.readInt();
                switch (command) {
                    case 12: 
                    case 13: {
                        try {
                            long jobId = serverSession.inServerToAgent.readLong();
                            long to = serverSession.inServerToAgent.readLong();
                            byte[] msg = NTalkUtils.readArray(serverSession.inServerToAgent);
                            ClientSession cliSession = (ClientSession)this.sessionsById.get(to);
                            if (cliSession != null) {
                                cliSession.outAgentToClient.writeInt(command);
                                cliSession.outAgentToClient.writeLong(jobId);
                                cliSession.outAgentToClient.writeUTF(serverSession.service);
                                if (command == 13) {
                                    cliSession.outAgentToClient.writeInt(-22);
                                }
                                NTalkUtils.writeArray(msg, cliSession.outAgentToClient);
                            }
                            ServerSession serverSession2 = serverSession;
                            synchronized (serverSession2) {
                                serverSession.outAgentToServer.writeInt(cliSession != null ? 257 : 259);
                                serverSession.outAgentToServer.writeLong(jobId);
                                continue block30;
                            }
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    case 255: {
                        quit = true;
                        continue block30;
                    }
                }
                System.err.println("Pbm");
                quit = true;
            }
            return;
        }
        catch (EOFException quit) {
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            Map<Object, Session> map = this.sessionsByService;
            synchronized (map) {
                this.sessionsByService.remove(serverSession.service);
            }
            map = this.sessionsById;
            synchronized (map) {
                this.sessionsById.remove(serverSession.sessionId);
            }
            serverSession.close();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            System.out.println("close agent");
            this.closed = true;
            for (Session value : this.sessionsById.values().toArray(new Session[0])) {
                this.sessionsById.remove(value.sessionId);
                if (value instanceof ServerSession) {
                    this.sessionsByService.remove(((ServerSession)value).service);
                }
                value.close();
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ClientSession
    extends Session {
        DataInputStream inClientToAgent;
        DataOutputStream outAgentToClient;

        private ClientSession() {
        }

        @Override
        public void close() {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.inClientToAgent != null) {
                    this.inClientToAgent.close();
                    this.inClientToAgent = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.outAgentToClient != null) {
                    this.outAgentToClient.close();
                    this.outAgentToClient = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ServerSession
    extends Session {
        String service;
        DataInputStream inServerToAgent;
        DataOutputStream outAgentToServer;
        boolean closed;

        private ServerSession() {
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.inServerToAgent != null) {
                    this.inServerToAgent.close();
                    this.inServerToAgent = null;
                }
                this.inServerToAgent = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.outAgentToServer != null) {
                    this.outAgentToServer.close();
                    this.outAgentToServer = null;
                }
                this.outAgentToServer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static abstract class Session {
        Long sessionId;
        String challenge;
        Socket socket;

        private Session() {
        }

        public abstract void close();
    }
}

