/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitResult;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.lib.ssh.SShConnection;
import net.thevpc.nuts.lib.ssh.SshFileInputStream;
import net.thevpc.nuts.lib.ssh.SshListener;
import net.thevpc.nuts.lib.ssh.SshPath;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

class SshNutsPath
implements NutsPathSPI {
    private final SshPath path;
    private final NutsSession session;
    private SshListener listener;

    public SshNutsPath(SshPath path, NutsSession session) {
        this.path = path;
        this.session = session;
    }

    public static String getURLParentPath(String ppath) {
        if (ppath == null) {
            return null;
        }
        while (ppath.endsWith("/")) {
            ppath = ppath.substring(0, ppath.length() - 1);
        }
        if (ppath.isEmpty()) {
            return null;
        }
        int i = ppath.lastIndexOf(47);
        ppath = i <= 0 ? "/" : ppath.substring(0, i + 1);
        return ppath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsStream<NutsPath> list(NutsPath basePath) {
        try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            c.grabOutputString();
            int i = c.execStringCommand("ls " + this.path.getPath());
            if (i != 0) return NutsStream.ofEmpty((NutsSession)this.session);
            Object[] s = c.getOutputString().split("[\n|\r]");
            NutsStream nutsStream = NutsStream.of((Object[])s, (NutsSession)this.session).map(NutsFunction.of(x -> {
                String cc = this.path.getPath();
                if (!cc.endsWith("/")) {
                    cc = cc + "/";
                }
                cc = cc + x;
                return NutsPath.of((String)this.path.setPath(cc).toString(), (NutsSession)this.getSession());
            }, (String)"NutsPath::of"));
            return nutsStream;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NutsStream.ofEmpty((NutsSession)this.session);
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new NutsFormatSPI(){

            public void print(NutsPrintStream out) {
                NutsTextStyle _sep = NutsTextStyle.separator();
                NutsTextStyle _path = NutsTextStyle.path();
                NutsTextStyle _nbr = NutsTextStyle.number();
                NutsTexts text = NutsTexts.of((NutsSession)SshNutsPath.this.session);
                NutsTextBuilder sb = text.builder();
                String user = SshNutsPath.this.path.getUser();
                String host = SshNutsPath.this.path.getHost();
                int port = SshNutsPath.this.path.getPort();
                String path0 = SshNutsPath.this.path.getPath();
                String password = SshNutsPath.this.path.getPassword();
                String keyFile = SshNutsPath.this.path.getKeyFile();
                sb.append((NutsText)text.ofStyled("ssh://", _sep));
                if (user != null && user.trim().length() != 0) {
                    sb.append((Object)user).append((NutsText)text.ofStyled("@", _sep));
                }
                sb.append((Object)host);
                if (port >= 0) {
                    sb.append((NutsText)text.ofStyled(":", _sep)).append((NutsText)text.ofStyled(String.valueOf(port), _nbr));
                }
                if (!path0.startsWith("/")) {
                    sb.append((NutsText)text.ofStyled('/' + path0, _path));
                } else {
                    sb.append((NutsText)text.ofStyled(path0, _path));
                }
                if (password != null || keyFile != null) {
                    sb.append((NutsText)text.ofStyled("?", _sep));
                    boolean first = true;
                    if (password != null) {
                        first = false;
                        sb.append((Object)"password").append((NutsText)text.ofStyled("=", _sep)).append((Object)password);
                    }
                    if (keyFile != null) {
                        if (!first) {
                            sb.append((NutsText)text.ofStyled(",", _sep));
                        }
                        sb.append((Object)"key-file").append((NutsText)text.ofStyled("=", _sep)).append((Object)keyFile);
                    }
                }
                out.print((NutsString)sb.toText());
            }

            public boolean configureFirst(NutsCommandLine commandLine) {
                return false;
            }
        };
    }

    public String getName(NutsPath basePath) {
        String loc = this.getLocation(basePath);
        return loc == null ? "" : Paths.get(loc, new String[0]).getFileName().toString();
    }

    public String getProtocol(NutsPath basePath) {
        return "ssh";
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        return NutsPath.of((String)SshPath.toString(this.path.getHost(), this.path.getPort(), NutsPath.of((String)this.path.getPath(), (NutsSession)this.session).resolve(path).toString(), this.path.getUser(), this.path.getPassword(), this.path.getKeyFile()), (NutsSession)this.getSession());
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return NutsPath.of((String)SshPath.toString(this.path.getHost(), this.path.getPort(), NutsPath.of((String)this.path.getPath(), (NutsSession)this.session).resolve(path).toString(), this.path.getUser(), this.path.getPassword(), this.path.getKeyFile()), (NutsSession)this.getSession());
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        return NutsPath.of((String)SshPath.toString(this.path.getHost(), this.path.getPort(), NutsPath.of((String)this.path.getPath(), (NutsSession)this.session).resolveSibling(path).toString(), this.path.getUser(), this.path.getPassword(), this.path.getKeyFile()), (NutsSession)this.getSession());
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return NutsPath.of((String)SshPath.toString(this.path.getHost(), this.path.getPort(), NutsPath.of((String)this.path.getPath(), (NutsSession)this.session).resolveSibling(path).toString(), this.path.getUser(), this.path.getPassword(), this.path.getKeyFile()), (NutsSession)this.getSession());
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public URL toURL(NutsPath basePath) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve url from %s", (Object[])new Object[]{this.toString()}));
    }

    public Path toFile(NutsPath basePath) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve file from %s", (Object[])new Object[]{this.toString()}));
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        return false;
    }

    public boolean isOther(NutsPath basePath) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDirectory(NutsPath basePath) {
        try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            c.grabOutputString();
            int i = c.execStringCommand("file " + this.path.getPath());
            if (i > 0) {
                boolean bl = false;
                return bl;
            }
            String s = c.getOutputString();
            int ii = s.indexOf(58);
            if (ii > 0) {
                boolean bl = s.substring(i + 1).trim().equals("directory");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLocal(NutsPath basePath) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRegularFile(NutsPath basePath) {
        try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            c.grabOutputString();
            int i = c.execStringCommand("file " + this.path.getPath());
            if (i > 0) {
                boolean bl = false;
                return bl;
            }
            String s = c.getOutputString();
            int ii = s.indexOf(58);
            if (ii > 0) {
                boolean bl = !s.substring(i + 1).trim().equals("directory");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean exists(NutsPath basePath) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"not supported exists for %s", (Object[])new Object[]{this.toString()}));
    }

    public long getContentLength(NutsPath basePath) {
        return -1L;
    }

    public String getContentEncoding(NutsPath basePath) {
        return null;
    }

    public String getContentType(NutsPath basePath) {
        return null;
    }

    public String getLocation(NutsPath basePath) {
        return this.path.getPath();
    }

    public InputStream getInputStream(NutsPath basePath) {
        return new SshFileInputStream(this.path, this.session);
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"not supported output stream for %s", (Object[])new Object[]{this.toString()}));
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        try (SShConnection session = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            session.rm(this.path.getPath(), recurse);
        }
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            c.mkdir(this.path.getPath(), parents);
        }
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        return null;
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        return null;
    }

    public Instant getCreationInstant(NutsPath basePath) {
        return null;
    }

    public NutsPath getParent(NutsPath basePath) {
        String loc = SshNutsPath.getURLParentPath(this.path.getPath());
        if (loc == null) {
            return null;
        }
        return NutsPath.of((String)SshPath.toString(this.path.getHost(), this.path.getPort(), loc, this.path.getUser(), this.path.getPassword(), this.path.getKeyFile()), (NutsSession)this.getSession());
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        return basePath;
    }

    public NutsPath normalize(NutsPath basePath) {
        return NutsPath.of((String)this.toString(), (NutsSession)this.getSession());
    }

    public boolean isAbsolute(NutsPath basePath) {
        return true;
    }

    public String owner(NutsPath basePath) {
        return null;
    }

    public String group(NutsPath basePath) {
        return null;
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        return Collections.emptySet();
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public boolean isName(NutsPath basePath) {
        return false;
    }

    public int getPathCount(NutsPath basePath) {
        String location = this.getLocation(basePath);
        if (NutsBlankable.isBlank((String)location)) {
            return 0;
        }
        return NutsPath.of((String)location, (NutsSession)this.getSession()).getPathCount();
    }

    public boolean isRoot(NutsPath basePath) {
        String loc = this.getLocation(basePath);
        if (NutsBlankable.isBlank((String)loc)) {
            return false;
        }
        switch (loc) {
            case "/": 
            case "\\\\": {
                return true;
            }
        }
        return NutsPath.of((String)loc, (NutsSession)this.getSession()).isRoot();
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return basePath.getParent().getRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        EnumSet<NutsPathOption> optionsSet = EnumSet.noneOf(NutsPathOption.class);
        optionsSet.addAll(Arrays.asList(options));
        try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            c.grabOutputString();
            StringBuilder cmd = new StringBuilder();
            cmd.append("ls");
            if (!optionsSet.contains(NutsPathOption.FOLLOW_LINKS)) {
                cmd.append(" -type d,f");
            }
            if (maxDepth > 0 && maxDepth != Integer.MAX_VALUE) {
                cmd.append(" -maxdepth ").append(maxDepth);
            }
            cmd.append(" ").append(this.path.getPath());
            int i = c.execStringCommand(cmd.toString());
            if (i != 0) return NutsStream.ofEmpty((NutsSession)this.session);
            Object[] s = c.getOutputString().split("[\n|\r]");
            NutsStream nutsStream = NutsStream.of((Object[])s, (NutsSession)this.session).map(NutsFunction.of(x -> {
                String cc = this.path.getPath();
                if (!cc.endsWith("/")) {
                    cc = cc + "/";
                }
                cc = cc + x;
                return NutsPath.of((String)this.path.setPath(cc).toString(), (NutsSession)this.getSession());
            }, (String)"NutsPath::of"));
            return nutsStream;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NutsStream.ofEmpty((NutsSession)this.session);
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        return NutsPath.of((String)SshPath.toString(this.path.getHost(), this.path.getPort(), NutsPath.of((String)this.getLocation(basePath), (NutsSession)this.getSession()).subpath(beginIndex, endIndex).toString(), this.path.getUser(), this.path.getPassword(), this.path.getKeyFile()), (NutsSession)this.getSession());
    }

    public String[] getItems(NutsPath basePath) {
        return NutsPath.of((String)this.getLocation(basePath), (NutsSession)this.getSession()).getItems();
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        SshPath sp;
        if (other.toString().startsWith("ssh:") && Objects.equals((sp = new SshPath(other.toString())).getHost(), this.path.getHost()) && Objects.equals(sp.getUser(), this.path.getUser())) {
            int r = -1;
            try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
                c.grabOutputString();
                r = c.execStringCommand("mv " + this.path.getPath() + " " + sp);
            }
            if (r != 0) {
                throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to move %s", (Object[])new Object[]{this}));
            }
            return;
        }
        this.copyTo(basePath, other, options);
        this.delete(basePath, true);
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        NutsCp.of((NutsSession)this.session).from(basePath).to(other).run();
    }

    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        for (NutsPath x : this.walk(basePath, maxDepth, options)) {
            NutsTreeVisitResult r;
            if (x.isDirectory()) {
                r = visitor.preVisitDirectory((Object)x, this.session);
                switch (r) {
                    case CONTINUE: {
                        break;
                    }
                    case TERMINATE: {
                        return;
                    }
                    case SKIP_SIBLINGS: 
                    case SKIP_SUBTREE: {
                        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{r}));
                    }
                }
                continue;
            }
            if (!x.isRegularFile()) continue;
            r = visitor.visitFile((Object)x, this.session);
            switch (r) {
                case CONTINUE: {
                    break;
                }
                case TERMINATE: {
                    return;
                }
                case SKIP_SIBLINGS: 
                case SKIP_SUBTREE: {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{r}));
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshNutsPath that = (SshNutsPath)o;
        return Objects.equals(this.path, that.path);
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }
}

