/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.ssh.DynamicInputStream;
import net.thevpc.nuts.lib.ssh.SShConnection;
import net.thevpc.nuts.lib.ssh.SshPath;

public class SshFileInputStream
extends DynamicInputStream {
    private final String from;
    private boolean init;
    private long filesize;
    private byte[] buf;
    private Channel channel;
    private OutputStream out;
    private InputStream in;
    private boolean closeConnection;
    private SShConnection connection;

    public SshFileInputStream(SshPath path, NutsSession nutsSession) {
        super(4096);
        SShConnection connection;
        this.from = path.getPath();
        this.init = false;
        this.filesize = 0L;
        this.buf = new byte[1024];
        this.closeConnection = true;
        this.connection = connection = new SShConnection(path.toAddress(), nutsSession);
    }

    SshFileInputStream(SShConnection connection, String path, boolean closeConnection) {
        super(4096);
        this.from = path;
        this.init = false;
        this.filesize = 0L;
        this.buf = new byte[1024];
        this.closeConnection = closeConnection;
        this.connection = connection;
    }

    @Override
    protected boolean requestMore() throws IOException {
        if (!this.init) {
            this.init = true;
            String command = "scp -f " + this.from;
            try {
                this.channel = this.connection.session.openChannel("exec");
            }
            catch (JSchException e) {
                throw new IOException(e);
            }
            ((ChannelExec)this.channel).setCommand(command);
            this.out = this.channel.getOutputStream();
            this.in = this.channel.getInputStream();
            try {
                this.channel.connect();
            }
            catch (JSchException e) {
                throw new IOException(e);
            }
            this.buf[0] = 0;
            this.out.write(this.buf, 0, 1);
            this.out.flush();
            int c = SShConnection.checkAck(this.in);
            if (c != 67) {
                return false;
            }
            this.in.read(this.buf, 0, 5);
            while (this.in.read(this.buf, 0, 1) >= 0 && this.buf[0] != 32) {
                this.filesize = this.filesize * 10L + (long)(this.buf[0] - 48);
            }
            String file = null;
            int i = 0;
            while (true) {
                this.in.read(this.buf, i, 1);
                if (this.buf[i] == 10) break;
                ++i;
            }
            file = new String(this.buf, 0, i);
            this.buf[0] = 0;
            this.out.write(this.buf, 0, 1);
            this.out.flush();
        }
        int foo = (long)this.buf.length < this.filesize ? this.buf.length : (int)this.filesize;
        if ((foo = this.in.read(this.buf, 0, foo)) < 0) {
            return false;
        }
        this.push(this.buf, 0, foo);
        this.filesize -= (long)foo;
        return this.filesize != 0L;
    }

    @Override
    public void close() throws IOException {
        if (SShConnection.checkAck(this.in) != 0) {
            if (this.closeConnection) {
                this.connection.close();
            }
            return;
        }
        this.buf[0] = 0;
        this.out.write(this.buf, 0, 1);
        this.out.flush();
        this.channel.disconnect();
        if (this.closeConnection) {
            this.connection.close();
        }
    }
}

