/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.lib.ssh.SshPath;
import net.thevpc.nuts.lib.ssh._StringUtils;

public class SshAddress {
    private static final Pattern pattern = Pattern.compile("^(?<protocol>(([a-zA-Z0-9_-]+)://))?((?<user>([^:?]+))@)?(?<host>[^:?]+)(:(?<port>[0-9]+))?(\\?(?<query>.+))?$");
    private final String user;
    private final String host;
    private final String password;
    private final String keyFile;
    private final int port;

    public SshAddress(String url) {
        Matcher m = pattern.matcher(url);
        if (m.find()) {
            String protocol = m.group("protocol");
            if (protocol != null && !protocol.equals("ssh://")) {
                throw new IllegalArgumentException("Illegal ssh protocol format " + url);
            }
        } else {
            throw new IllegalArgumentException("Illegal ssh protocol format " + url);
        }
        this.user = m.group("user");
        this.host = m.group("host");
        this.port = m.group("port") == null ? -1 : Integer.parseInt(m.group("port"));
        String q = m.group("query");
        Map<String, String> qm = _StringUtils.parseMap(q, ",");
        this.password = qm.get("password");
        this.keyFile = qm.get("key-file");
    }

    public SshAddress(String user, String host, int port, String keyFile, String password) {
        this.user = user;
        this.host = host;
        this.port = port;
        this.keyFile = keyFile;
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public SshAddress setUser(String user) {
        return new SshAddress(user, this.host, this.port, this.keyFile, this.password);
    }

    public String getHost() {
        return this.host;
    }

    public SshAddress setHost(String host) {
        return new SshAddress(this.user, host, this.port, this.keyFile, this.password);
    }

    public String getPassword() {
        return this.password;
    }

    public SshAddress setPassword(String password) {
        return new SshAddress(this.user, this.host, this.port, this.keyFile, password);
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public SshAddress setKeyFile(String keyFile) {
        return new SshAddress(this.user, this.host, this.port, keyFile, this.password);
    }

    public int getPort() {
        return this.port;
    }

    public SshAddress setPort(int port) {
        return new SshAddress(this.user, this.host, port, this.keyFile, this.password);
    }

    public SshPath getPath(String path) {
        return new SshPath(this.user, this.host, this.port, this.keyFile, this.password, path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ssh://");
        if (!NutsBlankable.isBlank((String)this.user)) {
            sb.append(this.user).append("@");
        }
        sb.append(this.host);
        if (this.port > 0) {
            sb.append(":").append(this.port);
        }
        if (this.password != null || this.keyFile != null) {
            sb.append("?");
            boolean first = true;
            if (this.password != null) {
                first = false;
                sb.append("password=").append(this.password);
            }
            if (this.keyFile != null) {
                if (!first) {
                    sb.append(',');
                }
                sb.append("key-file=").append(this.keyFile);
            }
        }
        return sb.toString();
    }
}

