/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import java.io.IOException;
import java.io.InputStream;

public abstract class DynamicInputStream
extends InputStream {
    private byte[] buffer;
    private int index;
    private int max;
    private boolean nomore;

    public DynamicInputStream(int bufferSize) {
        this.buffer = new byte[bufferSize <= 0 ? 1024 : bufferSize];
    }

    public int getAvailableCount() {
        return this.max - this.index;
    }

    @Override
    public int read() throws IOException {
        if (this.index < this.max) {
            return this.buffer[this.index++];
        }
        if (this.available() <= 0) {
            return -1;
        }
        return this.buffer[this.index++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.index >= this.max && this.available() <= 0) {
            return -1;
        }
        int v = Math.min(this.max - this.index, len);
        System.arraycopy(this.buffer, this.index, b, off, v);
        this.index += v;
        return v;
    }

    @Override
    public int available() throws IOException {
        int x = this.max - this.index;
        if (x <= 0) {
            if (this.nomore) {
                return 0;
            }
            if (!this.requestMore()) {
                this.nomore = true;
            }
            if ((x = this.max - this.index) <= 0) {
                this.nomore = true;
                return 0;
            }
        }
        return x;
    }

    private void shrink() {
        if (this.index > 0) {
            int len = this.max - this.index;
            System.arraycopy(this.buffer, this.index, this.buffer, 0, len);
            this.index = 0;
            this.max = len;
        }
    }

    public int push(byte[] other) {
        return this.push(other, 0, other.length);
    }

    public int push(byte[] other, int from, int count) {
        if (count + this.max < this.buffer.length) {
            System.arraycopy(other, from, this.buffer, this.max, count);
            this.max += count;
            return count;
        }
        this.shrink();
        int count2 = Math.min(this.buffer.length - this.max, count);
        System.arraycopy(other, from, this.buffer, this.max, count2);
        this.max += count2;
        return count2;
    }

    protected abstract boolean requestMore() throws IOException;
}

