/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.lib.ssh.SshAddress;
import net.thevpc.nuts.lib.ssh._StringUtils;

public class SshPath {
    private static Pattern pattern = Pattern.compile("^(?<protocol>(([a-zA-Z0-9_-]+)://))?((?<user>([^:?]+))@)?(?<host>[^:?/]+)(:(?<port>[0-9]+))?(?<path>([^?]*))(\\?(?<query>.+))?$");
    private String user = null;
    private String host = null;
    private String password = null;
    private String keyFile = null;
    private String path = null;
    private int port = -1;

    public SshPath(String url) {
        Matcher m = pattern.matcher(url);
        if (m.find()) {
            String protocol = m.group("protocol");
            if (!protocol.equals("ssh://")) {
                throw new IllegalArgumentException("Illegal ssh protocol format " + url);
            }
        } else {
            throw new IllegalArgumentException("Illegal ssh protocol format " + url);
        }
        this.user = m.group("user");
        this.host = m.group("host");
        this.port = m.group("port") == null ? -1 : Integer.parseInt(m.group("port"));
        this.path = m.group("path");
        String q = m.group("query");
        Map<String, String> qm = _StringUtils.parseMap(q, "&");
        this.password = qm.get("password");
        this.keyFile = qm.get("key-file");
    }

    public SshPath(String user, String host, int port, String keyFile, String password, String path) {
        this.user = user;
        this.host = host;
        this.port = port;
        this.keyFile = keyFile;
        this.password = password;
        this.path = path;
    }

    public SshPath setUser(String user) {
        return new SshPath(user, this.host, this.port, this.keyFile, this.password, this.path);
    }

    public SshPath setHost(String host) {
        return new SshPath(this.user, host, this.port, this.keyFile, this.password, this.path);
    }

    public SshPath setPassword(String password) {
        return new SshPath(this.user, this.host, this.port, this.keyFile, password, this.path);
    }

    public SshPath setKeyFile(String keyFile) {
        return new SshPath(this.user, this.host, this.port, keyFile, this.password, this.path);
    }

    public SshPath setPath(String path) {
        return new SshPath(this.user, this.host, this.port, this.keyFile, this.password, path);
    }

    public SshPath setPort(int port) {
        return new SshPath(this.user, this.host, port, this.keyFile, this.password, this.path);
    }

    public SshAddress toAddress() {
        return new SshAddress(this.user, this.host, this.port, this.keyFile, this.password);
    }

    public String getPath() {
        return this.path;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ssh://");
        if (this.user != null && this.user.trim().length() != 0) {
            sb.append(this.user).append("@");
        }
        sb.append(this.host);
        if (this.port >= 0) {
            sb.append(":").append(this.port);
        }
        if (!this.path.startsWith("/")) {
            sb.append('/');
        }
        sb.append(this.path);
        if (this.password != null || this.keyFile != null) {
            sb.append("?");
            boolean first = true;
            if (this.password != null) {
                first = false;
                sb.append("password=").append(this.password);
            }
            if (this.keyFile != null) {
                if (!first) {
                    sb.append(',');
                }
                sb.append("key-file=").append(this.keyFile);
            }
        }
        return sb.toString();
    }
}

