/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.lib.ssh.SShConnection;
import net.thevpc.nuts.lib.ssh.SshFileInputStream;
import net.thevpc.nuts.lib.ssh.SshListener;
import net.thevpc.nuts.lib.ssh.SshPath;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

class SshNutsPath
implements NutsPathSPI {
    private SshPath path;
    private NutsSession session;
    private SshListener listener;

    public SshNutsPath(SshPath path, NutsSession session) {
        this.path = path;
        this.session = session;
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentType() {
        return null;
    }

    public String asString() {
        return this.path.toString();
    }

    public NutsFormatSPI getFormatterSPI() {
        return new NutsFormatSPI(){

            public void print(NutsPrintStream out) {
                NutsTextStyle _sep = NutsTextStyle.separator();
                NutsTextStyle _path = NutsTextStyle.path();
                NutsTextStyle _nbr = NutsTextStyle.number();
                NutsTextManager text = SshNutsPath.this.session.getWorkspace().text();
                NutsTextBuilder sb = text.builder();
                String user = SshNutsPath.this.path.getUser();
                String host = SshNutsPath.this.path.getHost();
                int port = SshNutsPath.this.path.getPort();
                String path0 = SshNutsPath.this.path.getPath();
                String password = SshNutsPath.this.path.getPassword();
                String keyFile = SshNutsPath.this.path.getKeyFile();
                sb.append((NutsText)text.forStyled("ssh://", _sep));
                if (user != null && user.trim().length() != 0) {
                    sb.append((Object)user).append((NutsText)text.forStyled("@", _sep));
                }
                sb.append((Object)host);
                if (port >= 0) {
                    sb.append((NutsText)text.forStyled(":", _sep)).append((NutsText)text.forStyled(String.valueOf(port), _nbr));
                }
                if (!path0.startsWith("/")) {
                    sb.append((NutsText)text.forStyled('/' + path0, _path));
                } else {
                    sb.append((NutsText)text.forStyled(path0, _path));
                }
                if (password != null || keyFile != null) {
                    sb.append((NutsText)text.forStyled("?", _sep));
                    boolean first = true;
                    if (password != null) {
                        first = false;
                        sb.append((Object)"password").append((NutsText)text.forStyled("=", _sep)).append((Object)password);
                    }
                    if (keyFile != null) {
                        if (!first) {
                            sb.append((NutsText)text.forStyled(",", _sep));
                        }
                        sb.append((Object)"key-file").append((NutsText)text.forStyled("=", _sep)).append((Object)keyFile);
                    }
                }
                out.print((NutsString)sb.toText());
            }

            public boolean configureFirst(NutsCommandLine commandLine) {
                return false;
            }
        };
    }

    public InputStream inputStream() {
        return new SshFileInputStream(this.path, this.session);
    }

    public OutputStream outputStream() {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"not supported output stream for %s", (Object[])new Object[]{this.toString()}));
    }

    public long getContentLength() {
        return -1L;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(boolean recurse) {
        try (SShConnection session = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            session.rm(this.path.getPath(), recurse);
        }
    }

    public void mkdir(boolean parents) {
        try (SShConnection c = new SShConnection(this.path.toAddress(), this.getSession()).addListener(this.listener);){
            c.mkdir(this.path.getPath(), parents);
        }
    }

    public String getLocation() {
        return this.path.getPath();
    }

    public boolean exists() {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"not supported exists for %s", (Object[])new Object[]{this.toString()}));
    }

    public Instant getLastModifiedInstant() {
        return null;
    }
}

