/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.lib.ssh.NonClosableOutputStream;
import net.thevpc.nuts.lib.ssh.SshAddress;
import net.thevpc.nuts.lib.ssh.SshFileInputStream;
import net.thevpc.nuts.lib.ssh.SshListener;

public class SShConnection
implements AutoCloseable {
    Session session;
    NutsSession nutsSession;
    private boolean redirectErrorStream;
    private boolean failFast;
    private PrintStream out = new PrintStream(new NonClosableOutputStream(System.out));
    private PrintStream err = new PrintStream(new NonClosableOutputStream(System.err));
    private List<SshListener> listeners = new ArrayList<SshListener>();

    public SShConnection(String address, NutsSession nutsSession) {
        this(new SshAddress(address), nutsSession);
    }

    public SShConnection(SshAddress address, NutsSession nutsSession) {
        this.init(address.getUser(), address.getHost(), address.getPort(), address.getKeyFile(), address.getPassword(), nutsSession);
    }

    public SShConnection(String user, String host, int port, String keyFilePath, String keyPassword, NutsSession nutsSession) {
        this.init(user, host, port, keyFilePath, keyPassword, nutsSession);
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public SShConnection setRedirectErrorStream() {
        this.redirectErrorStream = true;
        return this;
    }

    public SShConnection setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public void reset() {
        this.failFast = false;
        this.redirectErrorStream = false;
        this.out = new PrintStream(new NonClosableOutputStream(System.out));
        this.err = new PrintStream(new NonClosableOutputStream(System.err));
    }

    public SShConnection addListener(SshListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
        return this;
    }

    public SShConnection removeListener(SshListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
        return this;
    }

    private void init(String user, String host, int port, String keyFilePath, String keyPassword, NutsSession nutsSession) {
        this.nutsSession = nutsSession;
        try {
            JSch jsch = new JSch();
            if (keyFilePath == null && keyPassword == null) {
                keyFilePath = new File(System.getProperty("user.home"), ".ssh/id_rsa").getPath();
            }
            if (keyFilePath != null) {
                if (keyPassword != null) {
                    jsch.addIdentity(keyFilePath, keyPassword);
                } else {
                    jsch.addIdentity(keyFilePath);
                }
            }
            if (user == null || user.length() == 0) {
                user = System.getProperty("user.name");
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            if (port <= 0) {
                port = 22;
            }
            this.session = jsch.getSession(user, host, port);
            if (keyPassword != null && keyPassword.length() > 0) {
                this.session.setConfig("PreferredAuthentications", "password");
                this.session.setPassword(keyPassword);
            }
            this.session.setConfig(config);
            this.session.connect();
        }
        catch (JSchException e) {
            throw new UncheckedIOException(new IOException(e.getMessage() + " (" + new SshAddress(user, host, port, keyFilePath, keyPassword) + ")", e));
        }
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public SShConnection failFast() {
        return this.setFailFast(true);
    }

    public SShConnection sailFast(boolean failFast) {
        return this.setFailFast(failFast);
    }

    public SShConnection setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public SShConnection redirectOutput(PrintStream out) {
        this.out = out;
        return this;
    }

    public boolean isGrabOutputString() {
        return this.out instanceof SPrintStream;
    }

    public SShConnection grabOutputString() {
        this.out = new SPrintStream();
        return this;
    }

    public SShConnection grabOutputString(boolean grab) {
        this.out = grab ? new SPrintStream() : new PrintStream(new NonClosableOutputStream(System.out));
        return this;
    }

    public static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    public int exec(List<String> command) {
        return this.exec(command.toArray(new String[0]));
    }

    public int exec(String ... command) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            String s;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if ((s = command[i]).isEmpty() || s.contains(" ")) {
                s = "\"" + s.replace("\"", "\\\"") + "\"";
            }
            sb.append(s);
        }
        return this.execStringCommand(sb.toString());
    }

    public int execStringCommand(String command) {
        int status = 205;
        for (SshListener listener : this.listeners) {
            listener.onExec(command);
        }
        try {
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            channel.setOutputStream((OutputStream)new NonClosableOutputStream(this.out));
            if (this.isRedirectErrorStream()) {
                ((ChannelExec)channel).setErrStream((OutputStream)new NonClosableOutputStream(this.out));
            } else {
                ((ChannelExec)channel).setErrStream((OutputStream)new NonClosableOutputStream(this.err));
            }
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    this.out.print(new String(tmp, 0, i));
                    continue;
                }
                if (channel.isClosed()) {
                    if (in.available() > 0) continue;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            status = channel.getExitStatus();
            channel.disconnect();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (JSchException ex) {
            throw new UncheckedIOException(new IOException(ex));
        }
        if (this.isFailFast() && status != 0) {
            throw new UncheckedIOException(new IOException("Ssh command exited with code " + status + (this.isGrabOutputString() ? " and message " + this.getOutputString().trim() : "")));
        }
        return status;
    }

    public void rm(String from, boolean R) {
        this.execStringCommand("rm " + (R ? "-R" : "") + " " + from);
    }

    public void mkdir(String from, boolean p) {
        this.execStringCommand("mkdir " + (p ? "-p" : "") + " " + from);
    }

    public byte[] readRemoteFile(String from) {
        try {
            int c;
            String command = "scp -f " + from;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            while ((c = SShConnection.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new ByteArrayOutputStream();
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                if (SShConnection.checkAck(in) != 0) {
                    return fos.toByteArray();
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                try {
                    if (fos == null) continue;
                    fos.close();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
            channel.disconnect();
            return fos.toByteArray();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (JSchException ex) {
            throw new UncheckedIOException(new IOException(ex));
        }
    }

    public void copyRemoteToLocal(String from, String to, boolean mkdir) {
        try {
            int c;
            String pp;
            for (SshListener listener : this.listeners) {
                listener.onGet(from, to, mkdir);
            }
            if (mkdir && (pp = new File(to).getParent()) != null) {
                this.mkdir(pp, true);
            }
            String prefix = null;
            String command = "scp -f " + from;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = SShConnection.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                FileOutputStream fos = new FileOutputStream(prefix == null ? to : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                if (SShConnection.checkAck(in) != 0) {
                    return;
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                try {
                    if (fos == null) continue;
                    fos.close();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
            channel.disconnect();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (JSchException ex) {
            throw new UncheckedIOException(new IOException(ex));
        }
    }

    public InputStream getInputStream(String from) {
        return this.getInputStream(from, false);
    }

    private InputStream getInputStream(String from, boolean closeConnection) {
        return new SshFileInputStream(this, from, closeConnection);
    }

    public void copyLocalToRemote(String from, String to, boolean mkdirs) {
        try {
            int len;
            if (from == null || from.trim().isEmpty()) {
                throw new IllegalArgumentException("missing source path");
            }
            if (to == null || to.trim().isEmpty()) {
                throw new IllegalArgumentException("missing target path");
            }
            for (SshListener listener : this.listeners) {
                listener.onPut(from, to, mkdirs);
            }
            if (mkdirs) {
                String p;
                boolean off = this.failFast;
                this.failFast = false;
                if (to.endsWith("/")) {
                    this.mkdir(to, true);
                } else if (to.contains("/") && (p = to.substring(0, to.lastIndexOf(47))).length() > 0) {
                    this.mkdir(p, true);
                }
                this.failFast = off;
            }
            boolean ptimestamp = true;
            String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + to;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (SShConnection.checkAck(in) != 0) {
                return;
            }
            File _lfile = new File(from);
            if (ptimestamp) {
                command = "T" + _lfile.lastModified() / 1000L + " 0";
                command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
                out.write(command.getBytes());
                out.flush();
                if (SShConnection.checkAck(in) != 0) {
                    return;
                }
            }
            long filesize = _lfile.length();
            command = "C0644 " + filesize + " ";
            command = from.lastIndexOf(47) > 0 ? command + from.substring(from.lastIndexOf(47) + 1) : command + from;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (SShConnection.checkAck(in) != 0) {
                return;
            }
            InputStream fis = this.prepareStream(new File(from));
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (SShConnection.checkAck(in) != 0) {
                return;
            }
            out.close();
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                this.out.println(ex);
            }
            channel.disconnect();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (JSchException ex) {
            throw new UncheckedIOException(new IOException(ex));
        }
    }

    @Override
    public void close() {
        this.session.disconnect();
    }

    public String getOutputString() {
        if (this.out instanceof SPrintStream) {
            return ((SPrintStream)this.out).getStringBuffer();
        }
        throw new UncheckedIOException(new IOException("Grab Output is not enabled. See grabOutputString()"));
    }

    public PrintStream getOut() {
        return this.out;
    }

    public SShConnection setOut(PrintStream out) {
        this.out = out;
        return this;
    }

    public InputStream prepareStream(File file) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(file);
        for (SshListener listener : this.listeners) {
            InputStream v = listener.monitorInputStream(in, file.length(), (NutsString)this.nutsSession.getWorkspace().text().toText((Object)file.getPath()));
            if (v == null) continue;
            return v;
        }
        return in;
    }

    private static class SPrintStream
    extends PrintStream {
        private ByteArrayOutputStream out;

        public SPrintStream() {
            this(new ByteArrayOutputStream());
        }

        public SPrintStream(ByteArrayOutputStream out1) {
            super(out1);
            this.out = out1;
        }

        public String getStringBuffer() {
            this.flush();
            return new String(this.out.toByteArray());
        }
    }
}

