/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.lib.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.lib.servlet._StringUtils;
import net.thevpc.nuts.toolbox.nutsserver.AdminServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.DefaultNutsWorkspaceServerManager;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;
import net.thevpc.nuts.toolbox.nutsserver.ServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.http.AbstractNutsHttpServletFacadeContext;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServletFacade;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServletFacadeContext;

public class NutsHttpServlet
extends HttpServlet {
    public static final String DEFAULT_HTTP_SERVER = "nuts-http-server";
    public static final int DEFAULT_HTTP_SERVER_PORT = 8899;
    private static final Logger LOG = Logger.getLogger(NutsHttpServlet.class.getName());
    private NutsHttpServletFacade facade;
    private String serverId = "";
    private String workspaceLocation = null;
    private String runtimeId = null;
    private int adminServerPort = -1;
    private Map<String, String> workspaces = new HashMap<String, String>();
    private boolean adminServer = true;
    private NutsServer adminServerRef;

    public static int parseInt(String v1, int defaultValue) {
        try {
            if (_StringUtils.isBlank(v1)) {
                return defaultValue;
            }
            return Integer.parseInt(_StringUtils.trim(v1));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void destroy() {
        super.destroy();
        if (this.adminServerRef != null) {
            try {
                this.adminServerRef.stop();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Unable to stop admin server", ex);
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Starting Nuts Http Server at url http://<your-server>" + config.getServletContext().getContextPath() + "/service");
        }
        if (this.adminServer && LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Starting Nuts admin Server at <localhost>:" + (this.adminServerPort < 0 ? 8899 : this.adminServerPort));
        }
        this.adminServerPort = NutsHttpServlet.parseInt(config.getInitParameter("nuts-admin-server-port"), -1);
        this.workspaceLocation = config.getInitParameter("nuts-workspace-location");
        this.runtimeId = config.getInitParameter("nuts-runtime-id");
        this.adminServer = Boolean.valueOf(config.getInitParameter("nuts-admin"));
        try {
            String s = config.getInitParameter("nuts-workspaces-map");
            if (s == null) {
                s = "";
            }
            this.workspaces = new HashMap<String, String>();
            for (String s1 : s.split("[\n;]")) {
                if ((s1 = s1.trim()).startsWith("#") || s1.isEmpty() || !s1.contains("=")) continue;
                String[] kv = s1.split("=");
                this.workspaces.put(kv[0].trim(), kv[1].trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.workspaces == null) {
            this.workspaces = new LinkedHashMap<String, String>();
        }
        super.init(config);
        config.getServletContext().setAttribute(NutsHttpServletFacade.class.getName(), (Object)this.facade);
    }

    public void init() throws ServletException {
        super.init();
        HashMap<Object, NutsWorkspace> workspacesByLocation = new HashMap<Object, NutsWorkspace>();
        HashMap<String, NutsWorkspace> workspacesByWebContextPath = new HashMap<String, NutsWorkspace>();
        NutsWorkspace workspace = Nuts.openWorkspace((NutsWorkspaceOptions)Nuts.createOptionsBuilder().setRuntimeId(this.runtimeId).setWorkspace(this.workspaceLocation).setOpenMode(NutsOpenMode.OPEN_OR_CREATE).setArchetype("server").build()).getWorkspace();
        DefaultNutsWorkspaceServerManager serverManager = new DefaultNutsWorkspaceServerManager(workspace.createSession());
        if (this.workspaces.isEmpty()) {
            String wl = this.workspaceLocation == null ? "" : this.workspaceLocation;
            this.workspaces.put("", wl);
            workspacesByLocation.put(wl, workspace);
        }
        for (Map.Entry entry : this.workspaces.entrySet()) {
            NutsWorkspace ws;
            String webContext = (String)entry.getKey();
            String location = (String)entry.getValue();
            if (location == null) {
                location = "";
            }
            if ((ws = (NutsWorkspace)workspacesByLocation.get(location)) == null) {
                ws = Nuts.openWorkspace((NutsWorkspaceOptions)Nuts.createOptionsBuilder().setRuntimeId(this.runtimeId).setWorkspace(location).setOpenMode(NutsOpenMode.OPEN_OR_CREATE).setArchetype("server").build()).getWorkspace();
                workspacesByLocation.put(location, ws);
            }
            workspacesByWebContextPath.put(webContext, ws);
        }
        if (_StringUtils.isBlank(this.serverId)) {
            String serverName = DEFAULT_HTTP_SERVER;
            try {
                serverName = InetAddress.getLocalHost().getHostName();
                if (serverName != null && serverName.length() > 0) {
                    serverName = "nuts-" + serverName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (serverName == null) {
                serverName = DEFAULT_HTTP_SERVER;
            }
            this.serverId = serverName;
        }
        this.facade = new NutsHttpServletFacade(this.serverId, workspacesByWebContextPath);
        if (this.adminServer) {
            try {
                AdminServerConfig serverConfig = new AdminServerConfig();
                serverConfig.setPort(this.adminServerPort);
                this.adminServerRef = serverManager.startServer((ServerConfig)serverConfig);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Unable to start admin server", ex);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.facade.execute((NutsHttpServletFacadeContext)new ServletNutsHttpServletFacadeContext(req, resp));
    }

    private static class ServletNutsHttpServletFacadeContext
    extends AbstractNutsHttpServletFacadeContext {
        private final HttpServletRequest req;
        private final HttpServletResponse resp;

        public ServletNutsHttpServletFacadeContext(HttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
        }

        public String getRequestMethod() throws IOException {
            return this.req.getMethod();
        }

        public URI getRequestURI() throws IOException {
            try {
                String cp = this.req.getContextPath();
                String uri = this.req.getRequestURI();
                if (uri.startsWith(cp) && (uri = uri.substring(cp.length())).startsWith(this.req.getServletPath())) {
                    uri = uri.substring(this.req.getServletPath().length());
                }
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public OutputStream getResponseBody() throws IOException {
            return this.resp.getOutputStream();
        }

        public void sendError(int code, String msg) throws IOException {
            this.resp.sendError(code, msg);
        }

        public void sendResponseHeaders(int code, long length) throws IOException {
            if (length > 0L) {
                this.resp.setHeader("Content-length", Long.toString(length));
            }
            this.resp.setStatus(code);
        }

        public Set<String> getRequestHeaderKeys(String header) throws IOException {
            return new HashSet<String>(Collections.list(this.req.getHeaderNames()));
        }

        public String getRequestHeaderFirstValue(String header) throws IOException {
            return this.req.getHeader(header);
        }

        public List<String> getRequestHeaderAllValues(String header) throws IOException {
            return Collections.list(this.req.getHeaders(header));
        }

        public InputStream getRequestBody() throws IOException {
            return this.req.getInputStream();
        }

        public Map<String, List<String>> getParameters() throws IOException {
            LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
            for (String s : Collections.list(this.req.getParameterNames())) {
                for (String v : this.req.getParameterValues(s)) {
                    List li = m.computeIfAbsent(s, d -> new ArrayList());
                    li.add(v);
                }
            }
            return m;
        }

        public void addResponseHeader(String name, String value) throws IOException {
            this.resp.addHeader(name, value);
        }
    }
}

