/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl.impl;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;

public class JSourceUtils {
    public static final String NEWLINE = "\n";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] urlToCharArray(URL r) {
        try (InputStream in = r.openStream();){
            char[] cArray = JSourceUtils.inputStreamToCharArray(in);
            return cArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] fileToCharArray(File r) {
        try (FileInputStream in = new FileInputStream(r);){
            char[] cArray = JSourceUtils.inputStreamToCharArray(in);
            return cArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static char[] inputStreamToCharArray(InputStream r) {
        return JSourceUtils.readerToCharArray(new InputStreamReader(r));
    }

    public static char[] readerToCharArray(Reader r) {
        CharArrayWriter w = new CharArrayWriter();
        char[] cc = new char[1024];
        while (true) {
            int len;
            try {
                len = r.read(cc);
                if (len <= 0) {
                    break;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            w.write(cc, 0, len);
        }
        return w.toCharArray();
    }
}

