/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl.impl;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class IteratorUtils {
    public static <T, V> Iterator<V> mapOptional(final Iterator<T> base, final Function<T, Optional<V>> f) {
        return new Iterator<V>(){
            private V next;

            @Override
            public boolean hasNext() {
                while (base.hasNext()) {
                    Object t = base.next();
                    Optional o = (Optional)f.apply(t);
                    if (!o.isPresent()) continue;
                    this.next = o.get();
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public V next() {
                return this.next;
            }
        };
    }

    public static <T, V> Iterator<V> map(final Iterator<T> base, final Function<T, V> f) {
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public V next() {
                Object n = base.next();
                return f.apply(n);
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> base, final Predicate<T> p) {
        return new Iterator<T>(){
            private T next;

            @Override
            public boolean hasNext() {
                while (base.hasNext()) {
                    this.next = base.next();
                    if (!p.test(this.next)) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public T next() {
                return this.next;
            }
        };
    }
}

