/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Supplier;
import net.thevpc.common.classpath.ClassPathResource;
import net.thevpc.common.classpath.ClassPathResourceFilter;
import net.thevpc.common.classpath.ClassPathUtils;
import net.thevpc.common.textsource.impl.impl.JSourceUtils;

public class ZippedURLFileCharSupplier
implements Supplier<char[]> {
    private final URL url;
    private final String path;
    private final ClassPathResourceFilter filter;

    public ZippedURLFileCharSupplier(URL url, String path, ClassPathResourceFilter filter) {
        this.url = url;
        this.path = path;
        this.filter = filter;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[] get() {
        ClassPathResource r;
        Iterator iterator = ClassPathUtils.resolveResources((URL[])new URL[]{this.url}, (ClassPathResourceFilter)this.filter).iterator();
        do {
            if (!iterator.hasNext()) throw new IllegalArgumentException("source path not found " + this.url + "#" + this.path);
        } while (!(r = (ClassPathResource)iterator.next()).getPath().equals(this.path));
        try (InputStream in = r.open();){
            char[] cArray = JSourceUtils.inputStreamToCharArray(in);
            return cArray;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return String.valueOf(this.url);
    }
}

