/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import net.thevpc.common.textsource.JTextSource;
import net.thevpc.common.textsource.JTextSourceReport;
import net.thevpc.common.textsource.JTextSourceRoot;
import net.thevpc.common.textsource.impl.DefaultJTextSource;
import net.thevpc.common.textsource.impl.LogJSourceIterable;
import net.thevpc.common.textsource.impl.impl.URLCharSupplier;

public class JTextSourceResourceFile
implements JTextSourceRoot {
    String path;

    public JTextSourceResourceFile(String path) {
        this.path = path;
        if (path == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getId() {
        return this.path;
    }

    @Override
    public Iterable<JTextSource> iterate(JTextSourceReport log) {
        return new LogJSourceIterable(log){

            @Override
            public Iterator<JTextSource> iterator() {
                block8: {
                    URL resource;
                    String path2 = JTextSourceResourceFile.this.path;
                    if (path2.startsWith("/")) {
                        path2 = path2.substring(1);
                    }
                    if ((resource = ClassLoader.getSystemClassLoader().getResource(path2)) != null) {
                        try {
                            InputStream in = resource.openStream();
                            if (in != null) {
                                return Collections.singleton(new DefaultJTextSource("resource://" + path2, new InputStreamReader(in), new URLCharSupplier(resource))).iterator();
                            }
                            if (this.log != null) {
                                this.log.reportError("Q000", null, "resource not found : " + JTextSourceResourceFile.this.path);
                            }
                            break block8;
                        }
                        catch (IOException ioException) {
                            if (this.log != null) {
                                this.log.reportError("Q000", null, ioException.getMessage() + ". resource not found : " + JTextSourceResourceFile.this.path);
                            }
                            break block8;
                        }
                    }
                    if (this.log != null) {
                        this.log.reportError("Q000", null, "resource not found : " + JTextSourceResourceFile.this.path);
                    }
                }
                return Collections.emptyIterator();
            }
        };
    }
}

