/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.function.Supplier;
import net.thevpc.common.classpath.ClassPathResource;
import net.thevpc.common.classpath.ClassPathResourceFilter;
import net.thevpc.common.classpath.ClassPathUtils;
import net.thevpc.common.textsource.impl.impl.JSourceUtils;

public class ContextClassLoaderCharSupplier
implements Supplier<char[]> {
    private final String path;
    private final ClassPathResourceFilter filter;

    public ContextClassLoaderCharSupplier(String path, ClassPathResourceFilter filter) {
        this.path = path;
        this.filter = filter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[] get() {
        ClassPathResource r;
        Iterator iterator = ClassPathUtils.resolveContextResources((ClassPathResourceFilter)this.filter, (boolean)false).iterator();
        do {
            if (!iterator.hasNext()) throw new IllegalArgumentException("source resource not found " + this.path);
        } while (!(r = (ClassPathResource)iterator.next()).getPath().equals(this.path));
        try (InputStream in = r.open();){
            char[] cArray = JSourceUtils.inputStreamToCharArray(in);
            return cArray;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return String.valueOf(this.path);
    }
}

