/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import net.thevpc.common.textsource.JTextSource;
import net.thevpc.common.textsource.JTextSourceFactory;
import net.thevpc.common.textsource.JTextSourceReport;
import net.thevpc.common.textsource.JTextSourceRoot;
import net.thevpc.common.textsource.impl.DefaultJTextSource;
import net.thevpc.common.textsource.impl.LogJSourceIterable;
import net.thevpc.common.textsource.impl.impl.URLCharSupplier;

public class JTextSourceFileURL
implements JTextSourceRoot {
    private URL url;

    public JTextSourceFileURL(URL url) {
        this.url = url;
        if (url == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getId() {
        return this.url.toString();
    }

    @Override
    public Iterable<JTextSource> iterate(JTextSourceReport log) {
        return new LogJSourceIterable(log){

            @Override
            public Iterator<JTextSource> iterator() {
                block7: {
                    URL resource;
                    if (JTextSourceFileURL.this.url.getProtocol().equals("file")) {
                        try {
                            File f = Paths.get(JTextSourceFileURL.this.url.toURI()).toFile();
                            return JTextSourceFactory.rootFile(f).iterator();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    if ((resource = JTextSourceFileURL.this.url) != null) {
                        try {
                            InputStream in = resource.openStream();
                            if (in != null) {
                                return Collections.singleton(new DefaultJTextSource(JTextSourceFileURL.this.url.toString(), new InputStreamReader(in), new URLCharSupplier(resource))).iterator();
                            }
                        }
                        catch (IOException e) {
                            if (this.log == null) break block7;
                            this.log.reportError("Q000", null, e.getMessage() + ". url  not found : " + JTextSourceFileURL.this.url);
                        }
                    }
                }
                return Collections.emptyIterator();
            }
        };
    }
}

