/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.thevpc.common.textsource.JTextSource;
import net.thevpc.common.textsource.JTextSourceReport;
import net.thevpc.common.textsource.JTextSourceRoot;
import net.thevpc.common.textsource.impl.DefaultJTextSource;
import net.thevpc.common.textsource.impl.FileCharSupplier;
import net.thevpc.common.textsource.impl.LogJSourceIterable;

public class JTextSourceFile
implements JTextSourceRoot {
    private File file;
    private String id;

    public JTextSourceFile(File file) {
        this.file = file;
        if (file == null) {
            throw new NullPointerException();
        }
        this.id = file.getAbsolutePath();
        try {
            this.id = file.getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Iterable<JTextSource> iterate(JTextSourceReport log) {
        return new LogJSourceIterable(log){

            @Override
            public Iterator<JTextSource> iterator() {
                block9: {
                    if (!JTextSourceFile.this.file.isFile() && !JTextSourceFile.this.file.isDirectory() && this.log != null) {
                        this.log.reportError("Q000", null, "file not found : " + JTextSourceFile.this.file.getPath());
                    }
                    if (JTextSourceFile.this.file.isFile()) {
                        try {
                            return Collections.singleton(new DefaultJTextSource(JTextSourceFile.this.file.getPath(), new FileReader(JTextSourceFile.this.file), new FileCharSupplier(JTextSourceFile.this.file))).iterator();
                        }
                        catch (IOException e) {
                            if (this.log == null) break block9;
                            this.log.reportError("Q000", null, e.getMessage() + " : " + JTextSourceFile.this.file.getPath());
                        }
                    }
                }
                try {
                    return Files.walk(JTextSourceFile.this.file.toPath(), new FileVisitOption[0]).filter(x -> Files.isRegularFile(x, new LinkOption[0])).map(x -> x.toFile()).filter(x -> x.getName().endsWith(".hl")).map(x -> {
                        try {
                            return new DefaultJTextSource(x.toString(), new FileReader((File)x), new FileCharSupplier((File)x));
                        }
                        catch (Exception e) {
                            if (this.log != null) {
                                this.log.reportError("Q000", null, e.getMessage() + " : " + JTextSourceFile.this.file.getPath());
                            }
                            return null;
                        }
                    }).filter(Objects::nonNull).iterator();
                }
                catch (NoSuchFileException e) {
                    if (this.log != null) {
                        this.log.reportError("Q000", null, "file not found : " + e.getMessage());
                    }
                    return Collections.emptyIterator();
                }
                catch (IOException e) {
                    if (this.log != null) {
                        this.log.reportError("Q000", null, e.getMessage() + " : " + JTextSourceFile.this.file.getPath());
                    }
                    return Collections.emptyIterator();
                }
            }
        };
    }
}

