/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.function.Supplier;
import net.thevpc.common.textsource.JTextSource;
import net.thevpc.common.textsource.JTextSourceRange;

public class DefaultJTextSource
implements JTextSource {
    String name;
    Reader reader;
    Supplier<char[]> supplier;
    private boolean consumed = false;

    public DefaultJTextSource(String name, Reader reader, Supplier<char[]> supplier) {
        this.reader = reader;
        this.name = name;
        this.supplier = supplier;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Reader reader() {
        if (this.consumed) {
            return new StringReader(this.text());
        }
        this.consumed = true;
        return this.reader;
    }

    @Override
    public String text() {
        return new String(this.supplier.get());
    }

    @Override
    public char[] charArray() {
        return this.supplier.get();
    }

    @Override
    public JTextSourceRange range(int from, int to) {
        char[] chars = this.charArray();
        if (from < 0) {
            from = 0;
        }
        if (to > chars.length) {
            to = chars.length;
        }
        return new JTextSourceRange(from, Arrays.copyOfRange(chars, from, to));
    }
}

