/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource;

public class JTextSourceRange {
    private int start;
    private char[] value;

    public JTextSourceRange(int start, char[] value) {
        this.start = start;
        this.value = value;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.start + this.value.length;
    }

    public char[] value() {
        return this.value;
    }

    public JRangePointer trim(long cn, int window) {
        char[] content = this.value();
        int rcn = (int)cn - this.start();
        if (rcn >= content.length) {
            rcn = content.length - 1;
        }
        int min = rcn;
        int max = rcn;
        while (min - 1 >= 0 && rcn - min + 1 < window && content[min - 1] != '\n' && content[min - 1] != '\r') {
            --min;
        }
        while (min < rcn && Character.isWhitespace(content[min])) {
            ++min;
        }
        while (max < content.length && (long)max - cn < (long)window && content[max] != '\n' && content[max] != '\r') {
            ++max;
        }
        return new JRangePointer(new String(content, min, max - min), rcn - min);
    }

    public static class JRangePointer {
        private String text;
        private int offset;

        public JRangePointer(String text, int offset) {
            this.text = text;
            this.offset = offset;
        }

        public String getText() {
            return this.text;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

