/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource;

import net.thevpc.common.textsource.JTextSourcePosition;
import net.thevpc.common.textsource.JTextSourcePositionValue;
import net.thevpc.common.textsource.SimpleJTextSourceToken;

public class JTextSourcePositionTracker
implements JTextSourcePosition,
Cloneable {
    private int currentRowNumber = 0;
    private int currentColumnNumber = 0;
    private int currentCharNumber = 0;
    private int currentTokenNumber = 0;

    @Override
    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    @Override
    public int getCurrentColumnNumber() {
        return this.currentColumnNumber;
    }

    @Override
    public int getCurrentCharNumber() {
        return this.currentCharNumber;
    }

    @Override
    public int getCurrentTokenNumber() {
        return this.currentTokenNumber;
    }

    public String toString() {
        return "Position{currentRowNumber=" + this.currentRowNumber + ", currentColumnNumber=" + this.currentColumnNumber + ", currentCharNumber=" + this.currentCharNumber + ", currentTokensNumber=" + this.currentTokenNumber + "}";
    }

    @Override
    public JTextSourcePosition readOnly() {
        return new JTextSourcePositionValue(this);
    }

    public JTextSourcePositionTracker copy() {
        try {
            return (JTextSourcePositionTracker)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public SimpleJTextSourceToken onReadToken(SimpleJTextSourceToken token) {
        token.startLineNumber = this.getCurrentRowNumber();
        token.startColumnNumber = this.getCurrentColumnNumber();
        token.startCharacterNumber = this.getCurrentCharNumber();
        token.tokenNumber = this.getCurrentTokenNumber();
        String image = token.image;
        if (image != null) {
            char[] chars = image.toCharArray();
            this.onReadChars(chars);
        }
        token.endLineNumber = this.getCurrentRowNumber();
        token.endColumnNumber = this.getCurrentColumnNumber();
        token.endCharacterNumber = this.getCurrentCharNumber();
        return token;
    }

    public void onReadString(String chars) {
        this.onReadChars(chars.toCharArray());
    }

    public void onReadChar(char c) {
        ++this.currentCharNumber;
        switch (c) {
            case '\n': 
            case '\r': {
                ++this.currentRowNumber;
                this.currentColumnNumber = 0;
                break;
            }
            default: {
                ++this.currentColumnNumber;
            }
        }
    }

    public void onReadChars(char[] chars) {
        ++this.currentTokenNumber;
        this.currentCharNumber += chars.length;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\r': {
                    if (i + 1 < chars.length && chars[i + 1] == '\n') {
                        ++i;
                        ++this.currentRowNumber;
                        this.currentColumnNumber = 0;
                        continue block4;
                    }
                    ++this.currentRowNumber;
                    this.currentColumnNumber = 0;
                    continue block4;
                }
                case '\n': {
                    ++this.currentRowNumber;
                    this.currentColumnNumber = 0;
                    continue block4;
                }
                default: {
                    ++this.currentColumnNumber;
                }
            }
        }
    }
}

