/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.common.textsource;

import java.io.File;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import net.thevpc.common.textsource.JTextSource;
import net.thevpc.common.textsource.JTextSourceRoot;
import net.thevpc.common.textsource.impl.JTextSourceFile;
import net.thevpc.common.textsource.impl.JTextSourceFileURL;
import net.thevpc.common.textsource.impl.JTextSourceResourcesFolder;
import net.thevpc.common.textsource.impl.JTextSourceString;
import net.thevpc.common.textsource.impl.classpath.JTextSourceFolderURL;
import net.thevpc.common.textsource.impl.classpath.JTextSourceResourceFile;

public class JTextSourceFactory {
    public static JTextSource fromString(String text, String sourceName) {
        Iterator<JTextSource> iterator = JTextSourceFactory.rootString(text, sourceName).iterator();
        if (iterator.hasNext()) {
            JTextSource s = iterator.next();
            return s;
        }
        return null;
    }

    public static JTextSource fromURI(URI url) {
        try {
            Iterator<JTextSource> iterator = JTextSourceFactory.rootURL(url.toURL()).iterator();
            if (iterator.hasNext()) {
                JTextSource s = iterator.next();
                return s;
            }
            return null;
        }
        catch (MalformedURLException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static JTextSource fromURL(URL url) {
        Iterator<JTextSource> iterator = JTextSourceFactory.rootURL(url).iterator();
        if (iterator.hasNext()) {
            JTextSource s = iterator.next();
            return s;
        }
        return null;
    }

    public static JTextSource fromFile(Path file) {
        Iterator<JTextSource> iterator = JTextSourceFactory.rootFile(file.toFile()).iterator();
        if (iterator.hasNext()) {
            JTextSource s = iterator.next();
            return s;
        }
        return null;
    }

    public static JTextSource fromFile(File file) {
        Iterator<JTextSource> iterator = JTextSourceFactory.rootFile(file).iterator();
        if (iterator.hasNext()) {
            JTextSource s = iterator.next();
            return s;
        }
        return null;
    }

    public static JTextSourceRoot rootFile(File file) {
        return new JTextSourceFile(file);
    }

    public static JTextSourceRoot rootString(String text, String sourceName) {
        return new JTextSourceString(text, sourceName);
    }

    public static JTextSourceRoot rootURL(URL url) {
        return new JTextSourceFileURL(url);
    }

    public static JTextSourceRoot rootURLFolder(URL url, String fileNameFilter) {
        return new JTextSourceFolderURL(url, fileNameFilter);
    }

    public static JTextSourceRoot rootResourceFolder(String url, String fileNameFilter) {
        return new JTextSourceResourcesFolder(url, fileNameFilter);
    }

    public static JTextSourceRoot rootResourceFile(String url) {
        return new JTextSourceResourceFile(url);
    }

    public static JTextSource fromURI(String file) {
        JTextSource last = null;
        for (JTextSource s : JTextSourceFactory.rootURI(file)) {
            if (last == null) {
                last = s;
                continue;
            }
            throw new IllegalArgumentException("Too Many files");
        }
        return last;
    }

    public static JTextSourceRoot rootURI(String uri) {
        if (uri.startsWith("file:")) {
            URI uri2 = null;
            try {
                uri2 = new URL(uri).toURI();
                if (uri2.getAuthority() != null && uri2.getAuthority().length() > 0) {
                    uri2 = new URL("file://" + uri.substring("file:".length())).toURI();
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            return JTextSourceFactory.rootFile(Paths.get(uri2).toFile());
        }
        if (uri.startsWith("string:")) {
            return JTextSourceFactory.rootString(uri.substring("string:".length()), "<Text>");
        }
        if (uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("jar:") || uri.startsWith("zip:")) {
            if (uri.endsWith("/")) {
                try {
                    return JTextSourceFactory.rootURLFolder(new URL(uri), null);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            try {
                return JTextSourceFactory.rootURL(new URL(uri));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (uri.startsWith("resource:")) {
            if (uri.endsWith("/")) {
                return JTextSourceFactory.rootResourceFolder(uri.substring("resource:".length()), null);
            }
            return JTextSourceFactory.rootResourceFile(uri.substring("resource:".length()));
        }
        if (uri.matches("[a-z]{2,}:.*")) {
            try {
                return JTextSourceFactory.rootURL(new URL(uri));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return JTextSourceFactory.rootFile(Paths.get(uri, new String[0]).toFile());
    }
}

