/*
 * Decompiled with CFR 0.152.
 */
package net.therore.pluginloader;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.therore.pluginloader.Plugin;
import net.therore.pluginloader.PluginClassLoader;

public class PluginLoader {
    public static final FileSystem FILE_SYSTEM = FileSystems.getDefault();
    private final PluginClassLoader classLoader;

    private static URL[] filesToURLs(File baseDirectory, String[] patterns) {
        return Files.walk(Paths.get(baseDirectory.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(path -> Arrays.stream(patterns).anyMatch(pattern -> FILE_SYSTEM.getPathMatcher("glob:" + pattern).matches((Path)path))).map(PluginLoader::getUrl).collect(Collectors.toList()).toArray(new URL[0]);
    }

    private static URL getUrl(Path file) {
        return file.toUri().toURL();
    }

    public PluginLoader(Plugin plugin) {
        this.classLoader = new PluginClassLoader(PluginLoader.filesToURLs(plugin.getBaseDirectory(), plugin.getClasspathPatterns()));
    }

    public Class loadClass(String name) {
        return this.classLoader.loadClass(name, false);
    }

    public <T> T invokeInPlugin(Callable<T> callable) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader previousThreadContextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            T t = callable.call();
            return t;
        }
        catch (ExceptionInInitializerError e) {
            Throwable e1 = e.getException();
            Throwable e2 = e1 != null ? e1 : e;
            e2.printStackTrace();
            throw e2;
        }
        catch (InvocationTargetException e) {
            Throwable e3;
            Throwable e2 = e.getTargetException();
            if (e2 instanceof ExceptionInInitializerError && (e3 = ((ExceptionInInitializerError)e2).getException()) != null) {
                e3.printStackTrace();
                throw e3;
            }
            e2.printStackTrace();
            throw e2;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            thread.setContextClassLoader(previousThreadContextClassLoader);
        }
    }
}

