/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.parser.expression;

import net.thebugmc.parser.expression.ExpressionPiece;
import net.thebugmc.parser.expression.PieceResult;
import net.thebugmc.parser.util.FilePointer;

public class NamePiece
extends ExpressionPiece {
    private final String specialChars;
    private final StringBuilder sb = new StringBuilder();

    public NamePiece(FilePointer ptr, String specialChars) {
        super(ptr);
        this.specialChars = specialChars;
    }

    @Override
    public PieceResult read(char c, FilePointer ptr) {
        if (!NamePiece.check(c, this.specialChars)) {
            return PieceResult.LEAVE;
        }
        this.sb.append(c);
        return PieceResult.CONTINUE;
    }

    public String name() {
        return String.valueOf(this.sb);
    }

    public String toString() {
        return this.name();
    }

    public static boolean check(char c, String specialChars) {
        return Character.isLetterOrDigit(c) || specialChars.indexOf(c) >= 0;
    }
}

