/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.parser.pattern;

import java.util.LinkedList;
import java.util.List;
import net.thebugmc.parser.expression.ExpressionPiece;
import net.thebugmc.parser.pattern.PatternResult;
import net.thebugmc.parser.pattern.Sentence;
import net.thebugmc.parser.util.ParserException;

@FunctionalInterface
public interface ParsePattern<T extends Sentence> {
    public PatternResult<T> parse(List<ExpressionPiece> var1);

    @SafeVarargs
    public static <T extends Sentence> PatternResult<T> matchOne(List<ExpressionPiece> expressions, ParsePattern<T> ... patterns) {
        if (expressions.isEmpty()) {
            return null;
        }
        for (ParsePattern<T> pattern : patterns) {
            PatternResult<T> result = pattern.parse(expressions);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @SafeVarargs
    public static <T extends Sentence> LinkedList<T> match(List<ExpressionPiece> expressions, ParsePattern<T> ... patterns) throws ParserException {
        expressions = new LinkedList<ExpressionPiece>(expressions);
        LinkedList<T> sentences = new LinkedList<T>();
        while (!expressions.isEmpty()) {
            PatternResult<T> result = ParsePattern.matchOne(expressions, patterns);
            List<ExpressionPiece> finalExpressions = expressions;
            ParserException.ASSERT(result != null, () -> ((ExpressionPiece)finalExpressions.get(0)).pointer(), "No pattern matches \"" + String.valueOf(finalExpressions.get(0)) + "\"");
            T r = result.result();
            if (r != null) {
                sentences.add(r);
            }
            expressions = expressions.subList(result.length(), expressions.size());
        }
        return sentences;
    }
}

