/*
 * Decompiled with CFR 0.152.
 */
package net.thauvin.erik.pinboard;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.thauvin.erik.pinboard.PinConfig;
import net.thauvin.erik.pinboard.PinboardPoster;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bB\u0019\b\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eB\u0005\u00a2\u0006\u0002\u0010\u000fJe\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u00032\u0014\b\u0002\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030'\"\u00020\u00032\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\"2\b\b\u0002\u0010+\u001a\u00020\"2\b\b\u0002\u0010,\u001a\u00020\"H\u0007\u00a2\u0006\u0002\u0010-J\u000e\u0010!\u001a\u00020\"2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0002J\u000e\u00102\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003J$\u00103\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000305H\u0002J\u001d\u00106\u001a\u0002072\u0006\u00101\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020\"H\u0002J\u0010\u0010;\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0010\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\"H\u0002R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0004R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006>"}, d2={"Lnet/thauvin/erik/pinboard/PinboardPoster;", "", "apiToken", "", "(Ljava/lang/String;)V", "properties", "Ljava/util/Properties;", "key", "(Ljava/util/Properties;Ljava/lang/String;)V", "propertiesFilePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "propertiesFile", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;)V", "()V", "apiEndPoint", "getApiEndPoint", "()Ljava/lang/String;", "setApiEndPoint", "getApiToken", "setApiToken", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "logger$delegate", "addPin", "", "url", "description", "extended", "tags", "", "dt", "Ljava/time/ZonedDateTime;", "replace", "shared", "toRead", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/time/ZonedDateTime;ZZZ)Z", "config", "Lnet/thauvin/erik/pinboard/PinConfig;", "cleanEndPoint", "method", "deletePin", "executeMethod", "params", "", "parseMethodResponse", "", "response", "parseMethodResponse$pinboard_poster", "validate", "validateUrl", "yesNo", "bool", "pinboard-poster"})
@SourceDebugExtension(value={"SMAP\nPinboardPoster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PinboardPoster.kt\nnet/thauvin/erik/pinboard/PinboardPoster\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,329:1\n26#2:330\n215#3,2:331\n*S KotlinDebug\n*F\n+ 1 PinboardPoster.kt\nnet/thauvin/erik/pinboard/PinboardPoster\n*L\n176#1:330\n270#1:331,2\n*E\n"})
public class PinboardPoster {
    @NotNull
    private String apiToken;
    @NotNull
    private String apiEndPoint;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final Lazy client$delegate;

    public PinboardPoster() {
        String string = System.getenv("PINBOARD_API_TOKEN");
        if (string == null) {
            string = "";
        }
        this.apiToken = string;
        this.apiEndPoint = "https://api.pinboard.in/v1/";
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        this.client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OkHttpClient>(this){
            final /* synthetic */ PinboardPoster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final OkHttpClient invoke() {
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                PinboardPoster pinboardPoster = this.this$0;
                OkHttpClient.Builder $this$invoke_u24lambda_u241 = builder;
                boolean bl = false;
                if (pinboardPoster.getLogger().isLoggable(Level.FINE)) {
                    void $this$invoke_u24lambda_u241_u24lambda_u240;
                    HttpLoggingInterceptor httpLoggingInterceptor;
                    HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
                    OkHttpClient.Builder builder2 = $this$invoke_u24lambda_u241;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241_u24lambda_u240.level(HttpLoggingInterceptor.Level.BODY);
                    builder2.addInterceptor((Interceptor)httpLoggingInterceptor);
                }
                return builder.build();
            }
        }));
    }

    public PinboardPoster(@NotNull String apiToken) {
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        this();
        this.apiToken = apiToken;
    }

    @JvmOverloads
    public PinboardPoster(@NotNull Properties properties, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this();
        String string = properties.getProperty(key, this.apiToken);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.apiToken = string;
    }

    public /* synthetic */ PinboardPoster(Properties properties, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "PINBOARD_API_TOKEN";
        }
        this(properties, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    public PinboardPoster(@NotNull Path propertiesFilePath, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)propertiesFilePath, (String)"propertiesFilePath");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this();
        if (Files.exists(propertiesFilePath, new LinkOption[0])) {
            Properties properties;
            Properties properties2 = properties = new Properties();
            PinboardPoster pinboardPoster = this;
            boolean bl = false;
            Closeable closeable = Files.newInputStream(propertiesFilePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                void $this$_init__u24lambda_u241;
                InputStream nis = (InputStream)closeable;
                boolean bl2 = false;
                $this$_init__u24lambda_u241.load(nis);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = properties.getProperty(key, this.apiToken);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            pinboardPoster.apiToken = string;
        }
    }

    public /* synthetic */ PinboardPoster(Path path, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "PINBOARD_API_TOKEN";
        }
        this(path, string);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull File propertiesFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Path path = propertiesFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this(path, key);
    }

    public /* synthetic */ PinboardPoster(File file, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "PINBOARD_API_TOKEN";
        }
        this(file, string);
    }

    @NotNull
    public final String getApiToken() {
        return this.apiToken;
    }

    public final void setApiToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apiToken = string;
    }

    @NotNull
    public final String getApiEndPoint() {
        return this.apiEndPoint;
    }

    public final void setApiEndPoint(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apiEndPoint = string;
    }

    @NotNull
    public final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Logger)object;
    }

    private final OkHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    public final boolean addPin(@NotNull PinConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String[] stringArray = config.getTags();
        return this.addPin(config.getUrl(), config.getDescription(), config.getExtended(), Arrays.copyOf(stringArray, stringArray.length), config.getDt(), config.getReplace(), config.getShared(), config.getToRead());
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String[] tags, @NotNull ZonedDateTime dt, boolean replace, boolean shared, boolean toRead) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        if (this.validate()) {
            if (!this.validateUrl(url)) {
                this.getLogger().severe("Please specify a valid URL to pin.");
            } else if (StringsKt.isBlank((CharSequence)description)) {
                this.getLogger().severe("Please specify a valid description to pin: `" + url + "`");
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)url), TuplesKt.to((Object)"description", (Object)description), TuplesKt.to((Object)"extended", (Object)extended), TuplesKt.to((Object)"tags", (Object)ArraysKt.joinToString$default((Object[])tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"dt", (Object)DateTimeFormatter.ISO_INSTANT.format(dt.withNano(0))), TuplesKt.to((Object)"replace", (Object)this.yesNo(replace)), TuplesKt.to((Object)"shared", (Object)this.yesNo(shared)), TuplesKt.to((Object)"toread", (Object)this.yesNo(toRead))};
                Map params = MapsKt.mapOf((Pair[])pairArray);
                return this.executeMethod("posts/add", params);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean addPin$default(PinboardPoster pinboardPoster, String string, String string2, String string3, String[] stringArray, ZonedDateTime zonedDateTime, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addPin");
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        }
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(...)");
            zonedDateTime = zonedDateTime2;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        return pinboardPoster.addPin(string, string2, string3, stringArray, zonedDateTime, bl, bl2, bl3);
    }

    public final boolean deletePin(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.validate()) {
            if (!this.validateUrl(url)) {
                this.getLogger().severe("Please specify a valid URL to delete.");
            } else {
                return this.executeMethod("posts/delete", MapsKt.mapOf((Pair)TuplesKt.to((Object)"url", (Object)url)));
            }
        }
        return false;
    }

    public final void parseMethodResponse$pinboard_poster(@NotNull String method, @NotNull String response) throws IOException {
        DocumentBuilderFactory documentBuilderFactory;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        DocumentBuilderFactory $this$parseMethodResponse_u24lambda_u242 = documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean bl = false;
        $this$parseMethodResponse_u24lambda_u242.setValidating(false);
        $this$parseMethodResponse_u24lambda_u242.setIgnoringElementContentWhitespace(true);
        $this$parseMethodResponse_u24lambda_u242.setIgnoringComments(true);
        $this$parseMethodResponse_u24lambda_u242.setCoalescing(false);
        $this$parseMethodResponse_u24lambda_u242.setNamespaceAware(false);
        DocumentBuilderFactory factory = documentBuilderFactory;
        if (((CharSequence)response).length() == 0) {
            throw new IOException("Response for " + method + " is empty.");
        }
        try {
            Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(response)));
            Object object = document.getElementsByTagName("result");
            String code = object != null && (object = object.item(0)) != null && (object = object.getAttributes()) != null && (object = object.getNamedItem("code")) != null ? object.getNodeValue() : null;
            CharSequence charSequence = code;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                throw new IOException("An error has occurred while executing " + method + ": " + code);
            }
            throw new IOException("An error has occurred while executing " + method + ".");
        }
        catch (SAXException e) {
            throw new IOException("Could not parse " + method + " response.", e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid input source for " + method + " response", e);
        }
    }

    private final String cleanEndPoint(String method) {
        return StringsKt.last((CharSequence)this.apiEndPoint) == '/' ? this.apiEndPoint + method : this.apiEndPoint + "/" + method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean executeMethod(String method, Map<String, String> params) {
        block13: {
            try {
                HttpUrl apiUrl = HttpUrl.Companion.parse(this.cleanEndPoint(method));
                if (apiUrl != null) {
                    HttpUrl.Builder builder;
                    HttpUrl.Builder $this$executeMethod_u24lambda_u244 = builder = apiUrl.newBuilder();
                    boolean bl = false;
                    Map<String, String> $this$forEach$iv = params;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> element$iv;
                        Map.Entry<String, String> it = element$iv = iterator.next();
                        boolean bl2 = false;
                        $this$executeMethod_u24lambda_u244.addQueryParameter(it.getKey(), it.getValue());
                    }
                    $this$executeMethod_u24lambda_u244.addQueryParameter("auth_token", this.apiToken);
                    HttpUrl httpUrl = builder.build();
                    Request request = new Request.Builder().url(httpUrl).build();
                    Closeable closeable = (Closeable)this.getClient().newCall(request).execute();
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        Response result = (Response)closeable;
                        boolean bl3 = false;
                        Object object = result.body();
                        if (object != null && (object = object.string()) != null) {
                            Object response = object;
                            boolean bl4 = false;
                            if (StringsKt.contains$default((CharSequence)((CharSequence)response), (CharSequence)"done", (boolean)false, (int)2, null)) {
                                boolean bl5 = true;
                                return bl5;
                            }
                            this.parseMethodResponse$pinboard_poster(method, (String)response);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                this.getLogger().severe("Invalid API end point: " + this.apiEndPoint);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return false;
    }

    private final boolean validate() {
        boolean isValid = true;
        if (!StringsKt.contains$default((CharSequence)this.apiToken, (char)':', (boolean)false, (int)2, null)) {
            this.getLogger().severe("Please specify a valid API token. (eg. user:TOKEN)");
            isValid = false;
        } else if (!this.validateUrl(this.apiEndPoint)) {
            this.getLogger().severe("Please specify a valid API end point. (eg. https://api.pinboard.in/v1/)");
            isValid = false;
        }
        return isValid;
    }

    private final boolean validateUrl(String url) {
        boolean isValid;
        boolean bl = isValid = !StringsKt.isBlank((CharSequence)url);
        if (isValid) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                this.getLogger().log(Level.FINE, "Invalid URL: " + url, e);
                isValid = false;
            }
        }
        return isValid;
    }

    private final String yesNo(boolean bool) {
        return bool ? "yes" : "no";
    }

    @JvmOverloads
    public PinboardPoster(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this(properties, null, 2, null);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull Path propertiesFilePath) {
        Intrinsics.checkNotNullParameter((Object)propertiesFilePath, (String)"propertiesFilePath");
        this(propertiesFilePath, null, 2, null);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull File propertiesFile) {
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        this(propertiesFile, null, 2, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String[] tags, @NotNull ZonedDateTime dt, boolean replace, boolean shared) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        return PinboardPoster.addPin$default(this, url, description, extended, tags, dt, replace, shared, false, 128, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String[] tags, @NotNull ZonedDateTime dt, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        return PinboardPoster.addPin$default(this, url, description, extended, tags, dt, replace, false, false, 192, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String[] tags, @NotNull ZonedDateTime dt) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        return PinboardPoster.addPin$default(this, url, description, extended, tags, dt, false, false, false, 224, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, String ... tags) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        return PinboardPoster.addPin$default(this, url, description, extended, tags, null, false, false, false, 240, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        return PinboardPoster.addPin$default(this, url, description, extended, null, null, false, false, false, 248, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return PinboardPoster.addPin$default(this, url, description, null, null, null, false, false, false, 252, null);
    }
}

