/*
 * Decompiled with CFR 0.152.
 */
package net.thauvin.erik.pinboard;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.thauvin.erik.pinboard.PinboardPoster;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bB\u0019\b\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eB\u0005\u00a2\u0006\u0002\u0010\u000fJT\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\u00032\b\b\u0002\u0010)\u001a\u00020#2\b\b\u0002\u0010*\u001a\u00020#2\b\b\u0002\u0010+\u001a\u00020#H\u0007J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0002J\u000e\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003J*\u0010/\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00032\u0018\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030201H\u0002J\u001d\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020#H\u0002J\u0010\u00108\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0010\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020#H\u0002R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0004R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u001b\u0012\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001f\u0010 \u00a8\u0006;"}, d2={"Lnet/thauvin/erik/pinboard/PinboardPoster;", "", "apiToken", "", "(Ljava/lang/String;)V", "properties", "Ljava/util/Properties;", "key", "(Ljava/util/Properties;Ljava/lang/String;)V", "propertiesFilePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "propertiesFile", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;)V", "()V", "apiEndPoint", "getApiEndPoint", "()Ljava/lang/String;", "setApiEndPoint", "getApiToken", "setApiToken", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "getLogger", "()Ljava/util/logging/Logger;", "logger$delegate", "addPin", "", "url", "description", "extended", "tags", "dt", "replace", "shared", "toRead", "cleanEndPoint", "method", "deletePin", "executeMethod", "params", "", "Lkotlin/Pair;", "parseMethodResponse", "", "response", "parseMethodResponse$pinboard_poster", "validate", "validateUrl", "yesNo", "bool", "pinboard-poster"})
public class PinboardPoster {
    @NotNull
    private String apiToken;
    @NotNull
    private String apiEndPoint;
    @NotNull
    private final Lazy logger$delegate;
    private final Lazy client$delegate;

    @NotNull
    public final String getApiToken() {
        return this.apiToken;
    }

    public final void setApiToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apiToken = string;
    }

    @NotNull
    public final String getApiEndPoint() {
        return this.apiEndPoint;
    }

    public final void setApiEndPoint(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apiEndPoint = string;
    }

    public static /* synthetic */ void getLogger$annotations() {
    }

    @NotNull
    public final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        PinboardPoster pinboardPoster = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    private final OkHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        PinboardPoster pinboardPoster = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String tags, @NotNull String dt, boolean replace, boolean shared, boolean toRead) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extended, (String)"extended");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        if (this.validate()) {
            if (!this.validateUrl(url)) {
                this.getLogger().severe("Please specify a valid URL to pin.");
            } else if (StringsKt.isBlank((CharSequence)description)) {
                this.getLogger().severe("Please specify a valid description to pin: `" + url + '`');
            } else {
                List params = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)"url", (Object)url), new Pair((Object)"description", (Object)description), new Pair((Object)"extended", (Object)extended), new Pair((Object)"tags", (Object)tags), new Pair((Object)"dt", (Object)dt), new Pair((Object)"replace", (Object)this.yesNo(replace)), new Pair((Object)"shared", (Object)this.yesNo(shared)), new Pair((Object)"toread", (Object)this.yesNo(toRead))});
                return this.executeMethod("posts/add", params);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean addPin$default(PinboardPoster pinboardPoster, String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addPin");
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        if ((n & 0x10) != 0) {
            string5 = "";
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        return pinboardPoster.addPin(string, string2, string3, string4, string5, bl, bl2, bl3);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String tags, @NotNull String dt, boolean replace, boolean shared) {
        return PinboardPoster.addPin$default(this, url, description, extended, tags, dt, replace, shared, false, 128, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String tags, @NotNull String dt, boolean replace) {
        return PinboardPoster.addPin$default(this, url, description, extended, tags, dt, replace, false, false, 192, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String tags, @NotNull String dt) {
        return PinboardPoster.addPin$default(this, url, description, extended, tags, dt, false, false, false, 224, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended, @NotNull String tags) {
        return PinboardPoster.addPin$default(this, url, description, extended, tags, null, false, false, false, 240, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description, @NotNull String extended) {
        return PinboardPoster.addPin$default(this, url, description, extended, null, null, false, false, false, 248, null);
    }

    @JvmOverloads
    public final boolean addPin(@NotNull String url, @NotNull String description) {
        return PinboardPoster.addPin$default(this, url, description, null, null, null, false, false, false, 252, null);
    }

    public final boolean deletePin(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.validate()) {
            if (!this.validateUrl(url)) {
                this.getLogger().severe("Please specify a valid URL to delete.");
            } else {
                return this.executeMethod("posts/delete", CollectionsKt.listOf((Object)new Pair((Object)"url", (Object)url)));
            }
        }
        return false;
    }

    public final void parseMethodResponse$pinboard_poster(@NotNull String method, @NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Object object = DocumentBuilderFactory.newInstance();
        boolean bl = false;
        boolean bl2 = false;
        DocumentBuilderFactory $this$apply = object;
        boolean bl3 = false;
        $this$apply.setValidating(false);
        $this$apply.setIgnoringElementContentWhitespace(true);
        $this$apply.setIgnoringComments(true);
        $this$apply.setCoalescing(false);
        $this$apply.setNamespaceAware(false);
        DocumentBuilderFactory factory = object;
        object = response;
        bl = false;
        if (object.length() == 0) {
            throw (Throwable)new IOException("Response for " + method + " is empty.");
        }
        try {
            Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(response)));
            Object object2 = document.getElementsByTagName("result");
            String code = object2 != null && (object2 = object2.item(0)) != null && (object2 = object2.getAttributes()) != null && (object2 = object2.getNamedItem("code")) != null ? object2.getNodeValue() : null;
            CharSequence charSequence = code;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                throw (Throwable)new IOException("An error has occurred while executing " + method + ": " + code);
            }
            throw (Throwable)new IOException("An error has occurred while executing " + method + '.');
        }
        catch (Exception e) {
            throw (Throwable)new IOException("Could not parse " + method + " response.", e);
        }
    }

    private final String cleanEndPoint(String method) {
        return StringsKt.endsWith$default((CharSequence)this.apiEndPoint, (char)'/', (boolean)false, (int)2, null) ? this.apiEndPoint + method : this.apiEndPoint + '/' + method;
    }

    private final boolean executeMethod(String method, List<Pair<String, String>> params) {
        try {
            HttpUrl apiUrl = HttpUrl.Companion.parse(this.cleanEndPoint(method));
            if (apiUrl != null) {
                String response;
                HttpUrl.Builder builder = apiUrl.newBuilder();
                boolean bl = false;
                boolean bl2 = false;
                HttpUrl.Builder $this$apply = builder;
                boolean bl3 = false;
                Iterable $this$forEach$iv = params;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl4 = false;
                    $this$apply.addQueryParameter((String)it.getFirst(), (String)it.getSecond());
                }
                $this$apply.addQueryParameter("auth_token", this.apiToken);
                HttpUrl httpUrl = builder.build();
                Request request = new Request.Builder().url(httpUrl).build();
                Response result = this.getClient().newCall(request).execute();
                ResponseBody responseBody = result.body();
                String string = response = responseBody != null ? responseBody.string() : null;
                if (response != null) {
                    if (StringsKt.contains$default((CharSequence)response, (CharSequence)"done", (boolean)false, (int)2, null)) {
                        return true;
                    }
                    this.parseMethodResponse$pinboard_poster(method, response);
                }
            } else {
                this.getLogger().severe("Invalid API end point: " + this.apiEndPoint);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    private final boolean validate() {
        boolean isValid = true;
        if (!StringsKt.contains$default((CharSequence)this.apiToken, (char)':', (boolean)false, (int)2, null)) {
            this.getLogger().severe("Please specify a valid API token. (eg. user:TOKEN)");
            isValid = false;
        } else if (!this.validateUrl(this.apiEndPoint)) {
            this.getLogger().severe("Please specify a valid API end point. (eg. https://api.pinboard.in/v1/)");
            isValid = false;
        }
        return isValid;
    }

    private final boolean validateUrl(String url) {
        boolean isValid;
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = isValid = !StringsKt.isBlank((CharSequence)charSequence);
        if (isValid) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                this.getLogger().log(Level.FINE, "Invalid URL: " + url, e);
                isValid = false;
            }
        }
        return isValid;
    }

    private final String yesNo(boolean bool) {
        return bool ? "yes" : "no";
    }

    public PinboardPoster() {
        String string = System.getenv("PINBOARD_API_TOKEN");
        if (string == null) {
            string = "";
        }
        this.apiToken = string;
        this.apiEndPoint = "https://api.pinboard.in/v1/";
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        this.client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OkHttpClient>(this){
            final /* synthetic */ PinboardPoster this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final OkHttpClient invoke() {
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                boolean bl = false;
                boolean bl2 = false;
                OkHttpClient.Builder $this$apply = builder;
                boolean bl3 = false;
                if (this.this$0.getLogger().isLoggable(Level.FINE)) {
                    void $this$apply2;
                    HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor;
                    OkHttpClient.Builder builder2 = $this$apply;
                    boolean bl6 = false;
                    $this$apply2.level(HttpLoggingInterceptor.Level.BODY);
                    Unit unit = Unit.INSTANCE;
                    builder2.addInterceptor((Interceptor)httpLoggingInterceptor);
                }
                return builder.build();
            }
            {
                this.this$0 = pinboardPoster;
                super(0);
            }
        }));
    }

    public PinboardPoster(@NotNull String apiToken) {
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        this();
        this.apiToken = apiToken;
    }

    @JvmOverloads
    public PinboardPoster(@NotNull Properties properties, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this();
        String string = properties.getProperty(key, this.apiToken);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.getProperty(key, apiToken)");
        this.apiToken = string;
    }

    public /* synthetic */ PinboardPoster(Properties properties, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "PINBOARD_API_TOKEN";
        }
        this(properties, string);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull Properties properties) {
        this(properties, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    public PinboardPoster(@NotNull Path propertiesFilePath, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)propertiesFilePath, (String)"propertiesFilePath");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this();
        if (Files.exists(propertiesFilePath, new LinkOption[0])) {
            Properties properties = new Properties();
            boolean bl = false;
            boolean bl2 = false;
            Properties properties2 = properties;
            PinboardPoster pinboardPoster = this;
            boolean bl3 = false;
            Closeable closeable = Files.newInputStream(propertiesFilePath, new OpenOption[0]);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                void $this$apply;
                InputStream nis = (InputStream)closeable;
                boolean bl6 = false;
                $this$apply.load(nis);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
            String string = properties.getProperty(key, this.apiToken);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Properties().apply {\n   \u2026etProperty(key, apiToken)");
            pinboardPoster.apiToken = string;
        }
    }

    public /* synthetic */ PinboardPoster(Path path, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "PINBOARD_API_TOKEN";
        }
        this(path, string);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull Path propertiesFilePath) {
        this(propertiesFilePath, null, 2, null);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull File propertiesFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Path path = propertiesFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"propertiesFile.toPath()");
        this(path, key);
    }

    public /* synthetic */ PinboardPoster(File file, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "PINBOARD_API_TOKEN";
        }
        this(file, string);
    }

    @JvmOverloads
    public PinboardPoster(@NotNull File propertiesFile) {
        this(propertiesFile, null, 2, null);
    }
}

