/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.javaflow.providers.asm5.ContinuableClassInfoResolver;
import org.apache.commons.javaflow.providers.asm5.IContinuableClassInfo;
import org.apache.commons.javaflow.providers.asm5.MaybeContinuableAnnotationVisitor;
import org.apache.commons.javaflow.providers.asm5.MaybeContinuableClassVisitor;
import org.apache.commons.javaflow.providers.asm5.SharedContinuableClassInfos;
import org.apache.commons.javaflow.spi.ClassMatcher;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

class IContinuableClassInfoResolver
implements ContinuableClassInfoResolver {
    private final Map<String, IContinuableClassInfo> visitedClasses = new HashMap<String, IContinuableClassInfo>();
    private final Set<String> processedAnnotations = new HashSet<String>();
    private final Set<String> continuableAnnotations = new HashSet<String>();
    private final Set<String> refreshClasses = new HashSet<String>();
    private final ResourceLoader resourceLoader;
    private final SharedContinuableClassInfos cciShared;
    private static final IContinuableClassInfo UNSUPPORTED_CLASS_INFO = new IContinuableClassInfo(true, Collections.<String>emptySet());

    IContinuableClassInfoResolver(ResourceLoader resourceLoader, SharedContinuableClassInfos cciShared) {
        this.resourceLoader = resourceLoader;
        this.cciShared = cciShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContinuableClassInfo resolve(String classInternalName) throws IOException {
        IContinuableClassInfo classInfo = this.getResolved(classInternalName);
        if (classInfo == null) {
            InputStream classBytes = this.resourceLoader.getResourceAsStream(classInternalName + ".class");
            try {
                IContinuableClassInfo iContinuableClassInfo = this.resolveContinuableClassInfo(classInternalName, new ClassReader(classBytes));
                return iContinuableClassInfo;
            }
            finally {
                if (null != classBytes) {
                    try {
                        classBytes.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return IContinuableClassInfoResolver.unmask(classInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isContinuableAnnotation(String annotationClassDescriptor) {
        switch (this.getAnnotationProcessingState(annotationClassDescriptor)) {
            case SUPPORTED: {
                return true;
            }
            case UNSUPPORTED: {
                return false;
            }
            case UNKNON: {
                boolean bl;
                this.markProcessedAnnotation(annotationClassDescriptor);
                Type type = Type.getType((String)annotationClassDescriptor);
                InputStream annotationBytes = this.resourceLoader.getResourceAsStream(type.getInternalName() + ".class");
                try {
                    bl = this.resolveContinuableAnnotation(annotationClassDescriptor, new ClassReader(annotationBytes));
                    if (null == annotationBytes) return bl;
                }
                catch (Throwable throwable) {
                    try {
                        if (null == annotationBytes) throw throwable;
                        try {
                            annotationBytes.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    annotationBytes.close();
                    return bl;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
        }
        throw new RuntimeException("Unknown annotation kind");
    }

    @Override
    public void release() {
        this.cciShared.mergeWith(this.visitedClasses, this.processedAnnotations, this.continuableAnnotations);
    }

    @Override
    public void reset(Collection<String> classNames) {
        this.visitedClasses.keySet().removeAll(classNames);
        this.refreshClasses.addAll(classNames);
    }

    IContinuableClassInfo resolve(String classInternalName, byte[] classBytes) {
        IContinuableClassInfo classInfo = this.getResolved(classInternalName);
        if (classInfo == null) {
            return this.resolveContinuableClassInfo(classInternalName, new ClassReader(classBytes));
        }
        return IContinuableClassInfoResolver.unmask(classInfo);
    }

    ClassMatcher veto() {
        return this.cciShared.veto();
    }

    private IContinuableClassInfo getResolved(String classInternalName) {
        if (this.refreshClasses.contains(classInternalName)) {
            return null;
        }
        IContinuableClassInfo result = this.visitedClasses.get(classInternalName);
        if (null != result) {
            return result;
        }
        result = this.cciShared.getResolved(classInternalName);
        if (null != result) {
            return result;
        }
        return null;
    }

    private IContinuableClassInfo resolveContinuableClassInfo(String classInternalName, ClassReader reader) {
        MaybeContinuableClassVisitor maybeContinuableClassVisitor = new MaybeContinuableClassVisitor(327680, this);
        reader.accept((ClassVisitor)maybeContinuableClassVisitor, 6);
        IContinuableClassInfo classInfo = maybeContinuableClassVisitor.toContinuableClassInfo();
        this.visitedClasses.put(classInternalName, null != classInfo ? classInfo : UNSUPPORTED_CLASS_INFO);
        this.refreshClasses.remove(classInternalName);
        return classInfo;
    }

    private boolean resolveContinuableAnnotation(String annotationClassDescriptor, ClassReader reader) {
        MaybeContinuableAnnotationVisitor maybeContinuableAnnotationVisitor = new MaybeContinuableAnnotationVisitor(327680, this);
        reader.accept((ClassVisitor)maybeContinuableAnnotationVisitor, 7);
        if (maybeContinuableAnnotationVisitor.isContinuable()) {
            this.markContinuableAnnotation(annotationClassDescriptor);
            return true;
        }
        return false;
    }

    private AnnotationProcessingState getAnnotationProcessingState(String annotationClassDescriptor) {
        if (this.cciShared.isContinuableAnnotation(annotationClassDescriptor)) {
            return AnnotationProcessingState.SUPPORTED;
        }
        if (this.cciShared.isProcessedAnnotation(annotationClassDescriptor)) {
            return AnnotationProcessingState.UNSUPPORTED;
        }
        if (this.continuableAnnotations.contains(annotationClassDescriptor)) {
            return AnnotationProcessingState.SUPPORTED;
        }
        if (this.processedAnnotations.contains(annotationClassDescriptor)) {
            return AnnotationProcessingState.UNSUPPORTED;
        }
        return AnnotationProcessingState.UNKNON;
    }

    private void markProcessedAnnotation(String annotationClassDescriptor) {
        this.processedAnnotations.add(annotationClassDescriptor);
    }

    private void markContinuableAnnotation(String annotationClassDescriptor) {
        this.markProcessedAnnotation(annotationClassDescriptor);
        this.continuableAnnotations.add(annotationClassDescriptor);
    }

    private static IContinuableClassInfo unmask(IContinuableClassInfo classInfo) {
        return classInfo == UNSUPPORTED_CLASS_INFO ? null : classInfo;
    }

    private static enum AnnotationProcessingState {
        UNKNON,
        UNSUPPORTED,
        SUPPORTED;

    }
}

