/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.apache.commons.javaflow.providers.asm5.ClassHierarchy;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

class FastClassVerifier
extends SimpleVerifier {
    private final ClassHierarchy classHierarchy;

    FastClassVerifier(int api, ClassHierarchy classHierarchy) {
        super(api, null, null, null, false);
        this.classHierarchy = classHierarchy;
    }

    protected boolean isAssignableFrom(Type t, Type u) {
        Type eu;
        Type et;
        if (t.equals((Object)u)) {
            return true;
        }
        if ("Lnull;".equals(u.getDescriptor()) && t.getSort() >= 9) {
            return true;
        }
        if (t.getSort() == 9) {
            if (u.getSort() != 9) {
                return false;
            }
            et = t.getElementType();
            eu = u.getElementType();
            int dt = t.getDimensions();
            int du = u.getDimensions();
            boolean isObject = et.equals((Object)BasicValue.REFERENCE_VALUE.getType());
            if (!(dt == du || dt < du && isObject)) {
                return false;
            }
        } else {
            et = t;
            eu = u;
        }
        Type commonType = this.classHierarchy.getCommonSuperType(eu, et);
        return commonType.equals((Object)et);
    }

    public BasicValue merge(BasicValue v, BasicValue w) {
        if (!v.equals((Object)w)) {
            int tsort;
            Type t = v.getType();
            Type u = w.getType();
            int n = tsort = t == null ? -1 : t.getSort();
            if (tsort == 10 || tsort == 9) {
                int usort;
                int n2 = usort = u == null ? -1 : u.getSort();
                if (usort == 10 || usort == 9) {
                    if ("Lnull;".equals(t.getDescriptor())) {
                        return w;
                    }
                    if ("Lnull;".equals(u.getDescriptor())) {
                        return v;
                    }
                    if (this.isAssignableFrom(t, u)) {
                        return v;
                    }
                    if (this.isAssignableFrom(u, t)) {
                        return w;
                    }
                    return new BasicValue(this.classHierarchy.getCommonSuperType(t, u));
                }
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return v;
    }

    protected Class<?> getClass(Type t) {
        throw new UnsupportedOperationException();
    }

    protected boolean isInterface(Type t) {
        throw new UnsupportedOperationException();
    }

    protected Type getSuperClass(Type t) {
        throw new UnsupportedOperationException();
    }
}

