/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.util.List;
import org.apache.commons.javaflow.providers.asm5.ContinuableMethodNode;
import org.apache.commons.javaflow.providers.asm5.MonitoringFrame;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

class ContinuableMethodVisitor
extends MethodVisitor {
    private static final String STACK_RECORDER = "org/apache/commons/javaflow/core/StackRecorder";
    private static final String POP_METHOD = "pop";
    private static final String PUSH_METHOD = "push";
    private final ContinuableMethodNode methodNode;
    private final Label startLabel = new Label();
    private final List<Label> labels;
    private final List<AbstractInsnNode> nodes;
    private final int stackRecorderVar;
    private int currentIndex = 0;
    private Frame currentFrame = null;
    private static String[] SUFFIXES = new String[]{"Object", "Int", "Int", "Int", "Int", "Int", "Float", "Long", "Double", "Object", "Object"};

    ContinuableMethodVisitor(int api, ContinuableMethodNode a) {
        super(api, a.mv);
        this.methodNode = a;
        this.labels = a.labels;
        this.nodes = a.nodes;
        this.stackRecorderVar = a.stackRecorderVar;
    }

    private static Type[] getArgumentTypes(AbstractInsnNode node) {
        if (node instanceof MethodInsnNode) {
            MethodInsnNode mnode = (MethodInsnNode)node;
            return Type.getArgumentTypes((String)mnode.desc);
        }
        InvokeDynamicInsnNode mnode = (InvokeDynamicInsnNode)node;
        return Type.getArgumentTypes((String)mnode.desc);
    }

    private static int getOwnerSize(AbstractInsnNode node) {
        if (node instanceof MethodInsnNode) {
            return node.getOpcode() == 184 ? 0 : 1;
        }
        return 0;
    }

    public void visitCode() {
        this.mv.visitCode();
        int fsize = this.labels.size();
        Label[] restoreLabels = new Label[fsize];
        for (int i = 0; i < restoreLabels.length; ++i) {
            restoreLabels[i] = new Label();
        }
        Label l0 = new Label();
        this.mv.visitMethodInsn(184, STACK_RECORDER, "get", "()Lorg/apache/commons/javaflow/core/StackRecorder;", false);
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(58, this.stackRecorderVar);
        this.mv.visitLabel(this.startLabel);
        this.mv.visitJumpInsn(198, l0);
        this.mv.visitVarInsn(25, this.stackRecorderVar);
        this.mv.visitFieldInsn(180, STACK_RECORDER, "isRestoring", "Z");
        this.mv.visitJumpInsn(153, l0);
        this.mv.visitVarInsn(25, this.stackRecorderVar);
        this.mv.visitMethodInsn(182, STACK_RECORDER, "popInt", "()I", false);
        this.mv.visitTableSwitchInsn(0, fsize - 1, l0, restoreLabels);
        for (int i = 0; i < fsize; ++i) {
            int j;
            Label frameLabel = this.labels.get(i);
            this.mv.visitLabel(restoreLabels[i]);
            AbstractInsnNode mnode = this.nodes.get(i);
            Frame frame = this.methodNode.getFrameByNode(mnode);
            int lsize = frame.getLocals();
            for (int j2 = lsize - 1; j2 >= 0; --j2) {
                BasicValue value = (BasicValue)frame.getLocal(j2);
                if (ContinuableMethodVisitor.isNull(value)) {
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(58, j2);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE || value == BasicValue.RETURNADDRESS_VALUE) continue;
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                Type type = value.getType();
                if (value.isReference()) {
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popObject", "()Ljava/lang/Object;", false);
                    Type t = value.getType();
                    String desc = t.getDescriptor();
                    if (desc.charAt(0) == '[') {
                        this.mv.visitTypeInsn(192, desc);
                    } else {
                        this.mv.visitTypeInsn(192, t.getInternalName());
                    }
                    this.mv.visitVarInsn(58, j2);
                    continue;
                }
                this.mv.visitMethodInsn(182, STACK_RECORDER, ContinuableMethodVisitor.getPopMethod(type), "()" + type.getDescriptor(), false);
                this.mv.visitVarInsn(type.getOpcode(54), j2);
            }
            if (frame instanceof MonitoringFrame) {
                int[] monitoredLocals = ((MonitoringFrame)frame).getMonitored();
                for (int j3 = 0; j3 < monitoredLocals.length; ++j3) {
                    this.mv.visitVarInsn(25, monitoredLocals[j3]);
                    this.mv.visitInsn(194);
                }
            }
            Type[] paramTypes = ContinuableMethodVisitor.getArgumentTypes(mnode);
            int argSize = paramTypes.length;
            int ownerSize = ContinuableMethodVisitor.getOwnerSize(mnode);
            int initSize = mnode.getOpcode() == 183 && ((MethodInsnNode)MethodInsnNode.class.cast((Object)mnode)).name.equals("<init>") ? 2 : 0;
            int ssize = frame.getStackSize();
            for (j = 0; j < ssize - argSize - ownerSize - initSize; ++j) {
                BasicValue value = (BasicValue)frame.getStack(j);
                if (ContinuableMethodVisitor.isNull(value)) {
                    this.mv.visitInsn(1);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE || value == BasicValue.RETURNADDRESS_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popObject", "()Ljava/lang/Object;", false);
                    this.mv.visitTypeInsn(192, value.getType().getInternalName());
                    continue;
                }
                Type type = value.getType();
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitMethodInsn(182, STACK_RECORDER, ContinuableMethodVisitor.getPopMethod(type), "()" + type.getDescriptor(), false);
            }
            if (ownerSize > 0) {
                BasicValue value = (BasicValue)frame.getStack(ssize - argSize - 1);
                if (ContinuableMethodVisitor.isNull(value)) {
                    this.mv.visitInsn(1);
                } else {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popReference", "()Ljava/lang/Object;", false);
                    this.mv.visitTypeInsn(192, value.getType().getInternalName());
                }
            }
            for (j = 0; j < argSize; ++j) {
                this.pushDefault(paramTypes[j]);
            }
            this.mv.visitJumpInsn(167, frameLabel);
        }
        this.mv.visitLabel(l0);
    }

    public void visitLabel(Label label) {
        if (this.currentIndex < this.labels.size() && label == this.labels.get(this.currentIndex)) {
            this.currentFrame = this.methodNode.getFrameByNode(this.nodes.get(this.currentIndex));
        }
        this.mv.visitLabel(label);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.mv.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        this.visitCall(186, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
        this.mv.visitMethodInsn(opcode, owner, name, desc, intf);
        this.visitCall(opcode, desc);
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.mv.visitMethodInsn(opcode, owner, name, desc);
        this.visitCall(opcode, desc);
    }

    private void visitCall(int opcode, String desc) {
        if (this.currentFrame != null) {
            boolean isInstanceMethod;
            boolean hasReturn;
            Label fl = new Label();
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitJumpInsn(198, fl);
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitFieldInsn(180, STACK_RECORDER, "isCapturing", "Z");
            this.mv.visitJumpInsn(153, fl);
            Type returnType = Type.getReturnType((String)desc);
            boolean bl = hasReturn = returnType != Type.VOID_TYPE;
            if (hasReturn) {
                this.mv.visitInsn(returnType.getSize() == 1 ? 87 : 88);
            }
            Type[] params = Type.getArgumentTypes((String)desc);
            int argSize = params.length;
            int ownerSize = opcode == 184 || opcode == 186 ? 0 : 1;
            int ssize = this.currentFrame.getStackSize() - argSize - ownerSize;
            for (int i = ssize - 1; i >= 0; --i) {
                BasicValue value = (BasicValue)this.currentFrame.getStack(i);
                if (ContinuableMethodVisitor.isNull(value)) {
                    this.mv.visitInsn(87);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitInsn(95);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "pushObject", "(Ljava/lang/Object;)V", false);
                    continue;
                }
                Type type = value.getType();
                if (type.getSize() > 1) {
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(88);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, ContinuableMethodVisitor.getPushMethod(type), "(" + type.getDescriptor() + ")V", false);
                    this.mv.visitInsn(87);
                    continue;
                }
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitInsn(95);
                this.mv.visitMethodInsn(182, STACK_RECORDER, ContinuableMethodVisitor.getPushMethod(type), "(" + type.getDescriptor() + ")V", false);
            }
            boolean bl2 = isInstanceMethod = (this.methodNode.access & 8) == 0;
            if (isInstanceMethod) {
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, STACK_RECORDER, "pushReference", "(Ljava/lang/Object;)V", false);
            }
            int fsize = this.currentFrame.getLocals();
            for (int j = 0; j < fsize; ++j) {
                BasicValue value = (BasicValue)this.currentFrame.getLocal(j);
                if (ContinuableMethodVisitor.isNull(value) || value == BasicValue.UNINITIALIZED_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitVarInsn(25, j);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "pushObject", "(Ljava/lang/Object;)V", false);
                    continue;
                }
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                Type type = value.getType();
                this.mv.visitVarInsn(type.getOpcode(21), j);
                this.mv.visitMethodInsn(182, STACK_RECORDER, ContinuableMethodVisitor.getPushMethod(type), "(" + type.getDescriptor() + ")V", false);
            }
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            if (this.currentIndex <= 5) {
                this.mv.visitInsn(3 + this.currentIndex);
            } else {
                this.mv.visitIntInsn(17, this.currentIndex);
            }
            this.mv.visitMethodInsn(182, STACK_RECORDER, "pushInt", "(I)V", false);
            if (this.currentFrame instanceof MonitoringFrame) {
                int[] monitoredLocals = ((MonitoringFrame)this.currentFrame).getMonitored();
                for (int j = 0; j < monitoredLocals.length; ++j) {
                    this.mv.visitVarInsn(25, monitoredLocals[j]);
                    this.mv.visitInsn(195);
                }
            }
            Type methodReturnType = Type.getReturnType((String)this.methodNode.desc);
            this.pushDefault(methodReturnType);
            this.mv.visitInsn(methodReturnType.getOpcode(172));
            this.mv.visitLabel(fl);
            ++this.currentIndex;
            this.currentFrame = null;
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endLabel = new Label();
        this.mv.visitLabel(endLabel);
        this.mv.visitLocalVariable("__stackRecorder", "Lorg/apache/commons/javaflow/core/StackRecorder;", null, this.startLabel, endLabel, this.stackRecorderVar);
        this.mv.visitMaxs(maxStack, maxLocals + 1);
    }

    private static boolean isNull(BasicValue value) {
        if (null == value) {
            return true;
        }
        if (!value.isReference()) {
            return false;
        }
        Type type = value.getType();
        return "Lnull;".equals(type.getDescriptor());
    }

    private void pushDefault(Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 8: {
                this.mv.visitInsn(14);
                break;
            }
            case 7: {
                this.mv.visitInsn(9);
                break;
            }
            case 6: {
                this.mv.visitInsn(11);
                break;
            }
            case 9: 
            case 10: {
                this.mv.visitInsn(1);
                break;
            }
            default: {
                this.mv.visitInsn(3);
            }
        }
    }

    private static String getPopMethod(Type type) {
        return POP_METHOD + SUFFIXES[type.getSort()];
    }

    private static String getPushMethod(Type type) {
        return PUSH_METHOD + SUFFIXES[type.getSort()];
    }
}

