/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

class MonitoringFrame
extends Frame {
    private List<Integer> monitored;

    MonitoringFrame(Frame frame) {
        super(frame);
    }

    MonitoringFrame(int nLocals, int nStack) {
        super(nLocals, nStack);
        this.monitored = new LinkedList<Integer>();
    }

    public void execute(AbstractInsnNode insn, Interpreter interpreter) throws AnalyzerException {
        boolean never = false;
        if (never) {
            super.execute(insn, interpreter);
            return;
        }
        int insnOpcode = insn.getOpcode();
        if (insnOpcode == 194 || insnOpcode == 195) {
            Value pop = this.pop();
            interpreter.unaryOperation(insn, pop);
            int local = -1;
            for (int i = 0; i < this.getLocals(); ++i) {
                if (this.getLocal(i) != pop) continue;
                local = i;
            }
            if (local > -1) {
                if (insnOpcode == 194) {
                    this.monitorEnter(local);
                } else {
                    this.monitorExit(local);
                }
            }
        } else {
            super.execute(insn, interpreter);
        }
    }

    public Frame init(Frame frame) {
        super.init(frame);
        this.monitored = frame instanceof MonitoringFrame ? new LinkedList<Integer>(((MonitoringFrame)((Object)MonitoringFrame.class.cast((Object)frame))).monitored) : new LinkedList<Integer>();
        return this;
    }

    int[] getMonitored() {
        int[] res = new int[this.monitored.size()];
        for (int i = 0; i < this.monitored.size(); ++i) {
            res[i] = this.monitored.get(i);
        }
        return res;
    }

    private void monitorEnter(int local) {
        this.monitored.add(local);
    }

    private void monitorExit(int local) {
        int index = this.monitored.lastIndexOf(local);
        if (index != -1) {
            this.monitored.remove(index);
        }
    }
}

